/*
  File autogenerated by gengetopt version 2.8
  generated with the following command:
  gengetopt --conf-parser 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Usage: %s [OPTIONS]...\n", PACKAGE);
  printf("   -h         --help             Print help and exit\n");
  printf("   -V         --version          Print version and exit\n");
  printf("   -f         --fg               Run in foreground (default=off)\n");
  printf("   -d         --debug            Run in debug mode (default=off)\n");
  printf("   -cSTRING   --conf=STRING      Read configuration file (default='/etc/ggsn.conf')\n");
  printf("              --pidfile=STRING   Filename of process id file (default='/var/run/ggsn.pid')\n");
  printf("              --statedir=STRING  Directory of nonvolatile data (default='/var/lib/ggsn/')\n");
  printf("   -lSTRING   --listen=STRING    Local interface\n");
  printf("   -nSTRING   --net=STRING       Network (default='192.168.0.0/24')\n");
  printf("              --ipup=STRING      Script to run after link-up\n");
  printf("              --ipdown=STRING    Script to run after link-down\n");
  printf("              --dynip=STRING     Dynamic IP address pool\n");
  printf("              --statip=STRING    Static IP address pool\n");
  printf("              --pcodns1=STRING   PCO DNS Server 1 (default='0.0.0.0')\n");
  printf("              --pcodns2=STRING   PCO DNS Server 2 (default='0.0.0.0')\n");
  printf("              --timelimit=INT    Exit after timelimit seconds (default='0')\n");
  printf("   -aSTRING   --apn=STRING       Access point name (default='internet')\n");
  printf("   -qINT      --qos=INT          Requested quality of service (default='0x0b921f')\n");
}


#ifndef HAVE_STRDUP
/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}
#endif /* HAVE_STRDUP */

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->fg_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->conf_given = 0 ;
  args_info->pidfile_given = 0 ;
  args_info->statedir_given = 0 ;
  args_info->listen_given = 0 ;
  args_info->net_given = 0 ;
  args_info->ipup_given = 0 ;
  args_info->ipdown_given = 0 ;
  args_info->dynip_given = 0 ;
  args_info->statip_given = 0 ;
  args_info->pcodns1_given = 0 ;
  args_info->pcodns2_given = 0 ;
  args_info->timelimit_given = 0 ;
  args_info->apn_given = 0 ;
  args_info->qos_given = 0 ;
#define clear_args() { \
  args_info->fg_flag = 0;\
  args_info->debug_flag = 0;\
  args_info->conf_arg = strdup("/etc/ggsn.conf") ;\
  args_info->pidfile_arg = strdup("/var/run/ggsn.pid") ;\
  args_info->statedir_arg = strdup("/var/lib/ggsn/") ;\
  args_info->listen_arg = NULL; \
  args_info->net_arg = strdup("192.168.0.0/24") ;\
  args_info->ipup_arg = NULL; \
  args_info->ipdown_arg = NULL; \
  args_info->dynip_arg = NULL; \
  args_info->statip_arg = NULL; \
  args_info->pcodns1_arg = strdup("0.0.0.0") ;\
  args_info->pcodns2_arg = strdup("0.0.0.0") ;\
  args_info->timelimit_arg = 0 ;\
  args_info->apn_arg = strdup("internet") ;\
  args_info->qos_arg = 0x0b921f ;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "fg",	0, NULL, 'f' },
        { "debug",	0, NULL, 'd' },
        { "conf",	1, NULL, 'c' },
        { "pidfile",	1, NULL, 0 },
        { "statedir",	1, NULL, 0 },
        { "listen",	1, NULL, 'l' },
        { "net",	1, NULL, 'n' },
        { "ipup",	1, NULL, 0 },
        { "ipdown",	1, NULL, 0 },
        { "dynip",	1, NULL, 0 },
        { "statip",	1, NULL, 0 },
        { "pcodns1",	1, NULL, 0 },
        { "pcodns2",	1, NULL, 0 },
        { "timelimit",	1, NULL, 0 },
        { "apn",	1, NULL, 'a' },
        { "qos",	1, NULL, 'q' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVfdc:l:n:a:q:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'f':	/* Run in foreground.  */
          if (args_info->fg_given)
            {
              fprintf (stderr, "%s: `--fg' (`-f') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->fg_given = 1;
          args_info->fg_flag = !(args_info->fg_flag);
          break;

        case 'd':	/* Run in debug mode.  */
          if (args_info->debug_given)
            {
              fprintf (stderr, "%s: `--debug' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->debug_given = 1;
          args_info->debug_flag = !(args_info->debug_flag);
          break;

        case 'c':	/* Read configuration file.  */
          if (args_info->conf_given)
            {
              fprintf (stderr, "%s: `--conf' (`-c') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->conf_given = 1;
          args_info->conf_arg = strdup (optarg);
          break;

        case 'l':	/* Local interface.  */
          if (args_info->listen_given)
            {
              fprintf (stderr, "%s: `--listen' (`-l') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->listen_given = 1;
          args_info->listen_arg = strdup (optarg);
          break;

        case 'n':	/* Network.  */
          if (args_info->net_given)
            {
              fprintf (stderr, "%s: `--net' (`-n') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->net_given = 1;
          args_info->net_arg = strdup (optarg);
          break;

        case 'a':	/* Access point name.  */
          if (args_info->apn_given)
            {
              fprintf (stderr, "%s: `--apn' (`-a') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->apn_given = 1;
          args_info->apn_arg = strdup (optarg);
          break;

        case 'q':	/* Requested quality of service.  */
          if (args_info->qos_given)
            {
              fprintf (stderr, "%s: `--qos' (`-q') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->qos_given = 1;
          args_info->qos_arg = strtol (optarg,&stop_char,0);
          break;


        case 0:	/* Long option with no short option */
          /* Filename of process id file.  */
          if (strcmp (long_options[option_index].name, "pidfile") == 0)
          {
            if (args_info->pidfile_given)
              {
                fprintf (stderr, "%s: `--pidfile' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pidfile_given = 1;
            args_info->pidfile_arg = strdup (optarg);
            break;
          }
          /* Directory of nonvolatile data.  */
          else if (strcmp (long_options[option_index].name, "statedir") == 0)
          {
            if (args_info->statedir_given)
              {
                fprintf (stderr, "%s: `--statedir' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->statedir_given = 1;
            args_info->statedir_arg = strdup (optarg);
            break;
          }
          /* Script to run after link-up.  */
          else if (strcmp (long_options[option_index].name, "ipup") == 0)
          {
            if (args_info->ipup_given)
              {
                fprintf (stderr, "%s: `--ipup' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ipup_given = 1;
            args_info->ipup_arg = strdup (optarg);
            break;
          }
          /* Script to run after link-down.  */
          else if (strcmp (long_options[option_index].name, "ipdown") == 0)
          {
            if (args_info->ipdown_given)
              {
                fprintf (stderr, "%s: `--ipdown' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ipdown_given = 1;
            args_info->ipdown_arg = strdup (optarg);
            break;
          }
          /* Dynamic IP address pool.  */
          else if (strcmp (long_options[option_index].name, "dynip") == 0)
          {
            if (args_info->dynip_given)
              {
                fprintf (stderr, "%s: `--dynip' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->dynip_given = 1;
            args_info->dynip_arg = strdup (optarg);
            break;
          }
          /* Static IP address pool.  */
          else if (strcmp (long_options[option_index].name, "statip") == 0)
          {
            if (args_info->statip_given)
              {
                fprintf (stderr, "%s: `--statip' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->statip_given = 1;
            args_info->statip_arg = strdup (optarg);
            break;
          }
          /* PCO DNS Server 1.  */
          else if (strcmp (long_options[option_index].name, "pcodns1") == 0)
          {
            if (args_info->pcodns1_given)
              {
                fprintf (stderr, "%s: `--pcodns1' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pcodns1_given = 1;
            args_info->pcodns1_arg = strdup (optarg);
            break;
          }
          /* PCO DNS Server 2.  */
          else if (strcmp (long_options[option_index].name, "pcodns2") == 0)
          {
            if (args_info->pcodns2_given)
              {
                fprintf (stderr, "%s: `--pcodns2' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pcodns2_given = 1;
            args_info->pcodns2_arg = strdup (optarg);
            break;
          }
          /* Exit after timelimit seconds.  */
          else if (strcmp (long_options[option_index].name, "timelimit") == 0)
          {
            if (args_info->timelimit_given)
              {
                fprintf (stderr, "%s: `--timelimit' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->timelimit_given = 1;
            args_info->timelimit_arg = strtol (optarg,&stop_char,0);
            break;
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}

#define CONFIGPARSERBUFSIZE 1024

int
cmdline_parser_configfile (char * const filename, struct gengetopt_args_info *args_info, int override)
{
  FILE* file;
  char linebuf[CONFIGPARSERBUFSIZE];
  int line_num = 0;
  int len;
  int fnum;
  char fopt[CONFIGPARSERBUFSIZE], farg[CONFIGPARSERBUFSIZE];
  char *stop_char;

  if ((file = fopen(filename, "r")) == NULL)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               PACKAGE, filename);
      exit (EXIT_FAILURE);
    }

  while ((fgets(linebuf, CONFIGPARSERBUFSIZE, file)) != NULL)
    {
      ++line_num;
      len = strlen(linebuf);
      if (len == CONFIGPARSERBUFSIZE-1)
        {
          fprintf (stderr, "%s: Line longer than %d characters found in configuration file '%s'\n",
                   PACKAGE, CONFIGPARSERBUFSIZE, filename);
          exit (EXIT_FAILURE);
        }

      if (linebuf[0] == '#')
        continue; /* Line was a comment */
    
      /* Get the option */
      if ((fnum = sscanf(linebuf, "%s %s", fopt, farg)) > 0)
        {
          if (!strcmp(fopt, "help"))
            {
              if (override || !args_info->help_given)
                {
                  args_info->help_given = 1;
                  
                }
              continue;
            }
          if (!strcmp(fopt, "version"))
            {
              if (override || !args_info->version_given)
                {
                  args_info->version_given = 1;
                  
                }
              continue;
            }
          if (!strcmp(fopt, "fg"))
            {
              if (override || !args_info->fg_given)
                {
                  args_info->fg_given = 1;
                  args_info->fg_flag = !(args_info->fg_flag);
                }
              continue;
            }
          if (!strcmp(fopt, "debug"))
            {
              if (override || !args_info->debug_given)
                {
                  args_info->debug_given = 1;
                  args_info->debug_flag = !(args_info->debug_flag);
                }
              continue;
            }
          if (!strcmp(fopt, "conf"))
            {
              if (override || !args_info->conf_given)
                {
                  args_info->conf_given = 1;
                  if (fnum == 2)
                    args_info->conf_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pidfile"))
            {
              if (override || !args_info->pidfile_given)
                {
                  args_info->pidfile_given = 1;
                  if (fnum == 2)
                    args_info->pidfile_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "statedir"))
            {
              if (override || !args_info->statedir_given)
                {
                  args_info->statedir_given = 1;
                  if (fnum == 2)
                    args_info->statedir_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "listen"))
            {
              if (override || !args_info->listen_given)
                {
                  args_info->listen_given = 1;
                  if (fnum == 2)
                    args_info->listen_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "net"))
            {
              if (override || !args_info->net_given)
                {
                  args_info->net_given = 1;
                  if (fnum == 2)
                    args_info->net_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "ipup"))
            {
              if (override || !args_info->ipup_given)
                {
                  args_info->ipup_given = 1;
                  if (fnum == 2)
                    args_info->ipup_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "ipdown"))
            {
              if (override || !args_info->ipdown_given)
                {
                  args_info->ipdown_given = 1;
                  if (fnum == 2)
                    args_info->ipdown_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "dynip"))
            {
              if (override || !args_info->dynip_given)
                {
                  args_info->dynip_given = 1;
                  if (fnum == 2)
                    args_info->dynip_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "statip"))
            {
              if (override || !args_info->statip_given)
                {
                  args_info->statip_given = 1;
                  if (fnum == 2)
                    args_info->statip_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pcodns1"))
            {
              if (override || !args_info->pcodns1_given)
                {
                  args_info->pcodns1_given = 1;
                  if (fnum == 2)
                    args_info->pcodns1_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pcodns2"))
            {
              if (override || !args_info->pcodns2_given)
                {
                  args_info->pcodns2_given = 1;
                  if (fnum == 2)
                    args_info->pcodns2_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "timelimit"))
            {
              if (override || !args_info->timelimit_given)
                {
                  args_info->timelimit_given = 1;
                  if (fnum == 2)
                    args_info->timelimit_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "apn"))
            {
              if (override || !args_info->apn_given)
                {
                  args_info->apn_given = 1;
                  if (fnum == 2)
                    args_info->apn_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "qos"))
            {
              if (override || !args_info->qos_given)
                {
                  args_info->qos_given = 1;
                  if (fnum == 2)
                    args_info->qos_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          

          /* Tried all known options. This one is unknown! */
          fprintf (stderr, "%s: Unknown option '%s' found in %s\n",
                   PACKAGE, fopt, filename);
          exit (EXIT_FAILURE);
        }
    } /* while */
  fclose(file); /* No error checking on close */

  return 0;
}
