\name{computeTestChiSquaredUserDefined}
\alias{computeTestChiSquaredUserDefined}
\title{Compute the chi squared test for UserDefined Distribution.}
\description{
This ROT function, called from a Test C++ object, is given a sample,
the UserDefined distribution parameter, and optionnaly a test level. 
It then returns the result of a X test against the null hypothesis 
that the sample has un underlying UserDefined distribution and returns a
list containing the result, statistic and test p-value.
}
\usage{
computeTestChiSquaredUserDefined(numericalSample,  x_i, p_i, testLevel = 0.95, estimatedParameters)
}
\arguments{
  \item{numericalSample}{the sample to be tested (numeric vector)}
  \item{x_i}{The UserDefined distribution $x_i$.(list containing a vector)}
  \item{p_i}{The UserDefined distribution $p_i$.(list containing a vector)}
  \item{testLevel}{the test level. (scalar in [0:1])}
  \item{estimatedParameters}{the test level. (scalar in [0:1])}
}
\value{
 A list is returned, containing :
  \item{testResult}{The result. 1 means H0 is not rejected. (scalar)}
  \item{threshold}{The threshold applied to the p-value when deciding the outcome of the test.}
  \item{pValue}{The test p-value. (scalar)}
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
}
\keyword{distribution}

