//                                               -*- C++ -*-
/**
 *  @file  Thread.cxx
 *  @brief The class Thread realizes multithreading implementation
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Thread.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "Threadable.hxx"
#include "ThreadStatus.hxx"
#include "Thread.hxx"
#include "OSS.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      CLASSNAMEINIT(Thread);

      /* Default constructor */
      Thread::Thread(const Threadable & th ///< The Threadable object this Thread object must run
		     ) : threadable_(th)
      {
        // Nothing to do
      }

      /* Copy constructor */
      Thread::Thread(const Thread & other ///< The copied Thread
		     ) : threadable_(other.threadable_)
      {
        // Nothing to do
      }

      /* Destructor */
      Thread::~Thread()
      {
        // Nothing to do
      }

      /* Assignment */
      Thread & Thread::operator =(const Thread & other)
      {
        if (this != &other)
	  { // Other is NOT me, so I can assign it to me
	  }
        return *this;
      }

      /* Comparison operator */
      Bool Thread::operator ==(const Thread & other) const
      {
        Bool sameThread = false;

        if (this != &other)
	  { // Other is NOT me, so I have to realize the comparison
	    // sameThread = ...
	  }

        else
          sameThread = true;

        return sameThread;
      }

      /* String converter */
      String Thread::__repr__() const
      {
        return OSS() << "class=" << Thread::GetClassName();
      }


      /*
       * Start running the Threadable object
       *
       * @todo implement Thread::start() method
       */
      void Thread::start() const
      {
	// TODO
      }

      /*
       * Cancel execution of the Threadable object
       * Because cancellation is not abortion, it is up to the
       * Threadable to accept cancellation. So calling this method
       * does not mean that the Thread will actually stop
       *
       * @todo implement Thread::cancel() method
       */
      void Thread::cancel() const
      {

      }

      /*
       * Get a ThreadStatus object that informs the user of
       * the internal status of the current thread
       *
       * @todo implement Thread::getStatus() method
       */
      const ThreadStatus Thread::getStatus() const
      {
	return ThreadStatus();
      }



    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
