//                                               -*- C++ -*-
/**
 *  @file  SamplingStrategy.hxx
 *  @brief 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: SamplingStrategy.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_SAMPLINGSTRATEGY_HXX
#define OPENTURNS_SAMPLINGSTRATEGY_HXX

#include "TypedInterfaceObject.hxx"
#include "SamplingStrategyImplementation.hxx"
#include "TypedInterfaceObject.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class SamplingStrategy
       */

      class SamplingStrategy
	: public Base::Common::TypedInterfaceObject<SamplingStrategyImplementation>
      {

	CLASSNAME;

      public:
	typedef SamplingStrategyImplementation::NumericalSample NumericalSample;

	/** Default constructor */
	explicit SamplingStrategy();

	/** Constructor with parameters */
        SamplingStrategy(const SamplingStrategyImplementation & implementation);

	/** Constructor with parameters */
        SamplingStrategy(Implementation & p_implementation);

	/** Constructor with parameters */
	explicit SamplingStrategy(const UnsignedLong dimension);


	/** Generate a set of directions */
	NumericalSample generate() const;

	/** Dimension accessor */
	void setDimension(const UnsignedLong dimension);
	UnsignedLong getDimension() const;

	/** String converter */
	String __repr__() const;

      } ; /* class SamplingStrategy */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SAMPLINGSTRATEGY_HXX */
