// SWIG file Copula.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-09-28 16:52:28 +0200 (lun. 28 sept. 2009) $
// Id : $Id: Copula.i 1349 2009-09-28 14:52:28Z dutka $

%{
#include "PythonWrappingFunctions.hxx"
#include "Copula.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Uncertainty::Model::Copula>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Uncertainty::Model::Copula
  convert<_PyObject_,OpenTURNS::Uncertainty::Model::Copula>(PyObject * pyObj)
  {
    void * ptr = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OpenTURNS__Uncertainty__Model__Copula, 0 |  0 ))) {
      OpenTURNS::Uncertainty::Model::Copula * p_copula = reinterpret_cast< OpenTURNS::Uncertainty::Model::Copula * >( ptr );
      return *p_copula;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OpenTURNS__Uncertainty__Model__CopulaImplementation, 0 |  0 ))) {
      OpenTURNS::Uncertainty::Model::CopulaImplementation * p_copula = reinterpret_cast< OpenTURNS::Uncertainty::Model::CopulaImplementation * >( ptr );
      return *p_copula;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OpenTURNS__Uncertainty__Model__Distribution, 0 |  0 ))) {
      OpenTURNS::Uncertainty::Model::Distribution * p_dist = reinterpret_cast< OpenTURNS::Uncertainty::Model::Distribution * >( ptr );
      return *p_dist;

    } else if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIGTYPE_p_OpenTURNS__Uncertainty__Model__DistributionImplementation, 0 |  0 ))) {
      OpenTURNS::Uncertainty::Model::DistributionImplementation * p_dist = reinterpret_cast< OpenTURNS::Uncertainty::Model::DistributionImplementation * >( ptr );
      return *p_dist;

    } else if (isAPython<_PySequence_>( pyObj )) {
      const UnsignedLong size = PySequence_Fast_GET_SIZE( pyObj );
      if (size != 2) {
        throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Sequence object has incorrect size " << size << ". Must be 2.";
      }
      PyObject * elt1 = PySequence_Fast_GET_ITEM( pyObj, 0 );
      check<_PyObject_>( elt1 );
      PyObject * elt2 = PySequence_Fast_GET_ITEM( pyObj, 1 );
      check<_PyString_>( elt2 );
      OpenTURNS::Uncertainty::Model::Copula copula = convert<_PyObject_,OpenTURNS::Uncertainty::Model::Copula>( elt1 );
      copula.setName( convert<_PyString_,OpenTURNS::String>( elt2 ) );

      return copula;

    } else {
      throw OpenTURNS::Base::Common::InvalidArgumentException(HERE) << "Object passed as argument is neither a Copula nor an object convertible to a Copula";
    }
    return OpenTURNS::Uncertainty::Model::Copula();
  }

} /* namespace OpenTURNS */

%}

%include Copula.hxx
namespace OpenTURNS { namespace Uncertainty { namespace Model { %extend Copula { Copula(const Copula & other) { return new OpenTURNS::Uncertainty::Model::Copula(other); } } }}}
