// SWIG file Interval.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-09-28 16:52:28 +0200 (lun. 28 sept. 2009) $
// Id : $Id: Interval.i 1349 2009-09-28 14:52:28Z dutka $

%{
#include "PythonWrappingFunctions.hxx"
#include "Interval.hxx"
%}

// class UnsignedLongCollection is defined in base_wrapper.i (module wrapper)
%pythoncode %{
class BoolCollection(wrapper.UnsignedLongCollection): pass
%}

%include Interval.hxx
namespace OpenTURNS { namespace Base { namespace Type {

%extend Interval {

  Interval(PyObject * pyObj1, PyObject * pyObj2)
  {
    OpenTURNS::check<OpenTURNS::_PySequence_>( pyObj1 );
    OpenTURNS::check<OpenTURNS::_PySequence_>( pyObj2 );
    return new OpenTURNS::Base::Type::Interval( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Type::NumericalPoint>( pyObj1 ),
	                                        OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Type::NumericalPoint>( pyObj2 ) );
  }

  Interval(PyObject * pyObj1, PyObject * pyObj2, PyObject * pyObj3, PyObject * pyObj4)
  {
    OpenTURNS::check<OpenTURNS::_PySequence_>( pyObj1 );
    OpenTURNS::check<OpenTURNS::_PySequence_>( pyObj2 );
    OpenTURNS::check<OpenTURNS::_PySequence_>( pyObj3 );
    OpenTURNS::check<OpenTURNS::_PySequence_>( pyObj4 );
    OpenTURNS::Base::Common::Pointer<OpenTURNS::Base::Type::Collection<OpenTURNS::UnsignedLong> > ptr3 = OpenTURNS::buildCollectionFromPySequence<OpenTURNS::UnsignedLong>( pyObj3 );
    OpenTURNS::Base::Common::Pointer<OpenTURNS::Base::Type::Collection<OpenTURNS::UnsignedLong> > ptr4 = OpenTURNS::buildCollectionFromPySequence<OpenTURNS::UnsignedLong>( pyObj4 );
    return new OpenTURNS::Base::Type::Interval( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Type::NumericalPoint>( pyObj1 ),
                                                OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Type::NumericalPoint>( pyObj2 ),
                                                *ptr3,
	                                        *ptr4 );
  }

}

}}}

namespace OpenTURNS { namespace Base { namespace Type { %extend Interval { Interval(const Interval & other) { return new OpenTURNS::Base::Type::Interval(other); } } }}}
