// SWIG file NearestPointAlgorithmImplementation.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
// Id : $Id: NearestPointAlgorithmImplementation.i 1262 2009-05-28 12:47:53Z dutka $

%{
#include "NearestPointAlgorithmImplementation.hxx"
%}

%include NearestPointAlgorithmImplementation.hxx

namespace OpenTURNS { namespace Base { namespace Optim {
/*
 * @class NearestPointAlgorithmImplementationResult
 * NearestPointAlgorithmImplementationResult stores the optimization result 
 */
class NearestPointAlgorithmImplementationResult: public
  OpenTURNS::Base::Common::PersistentObject
{
public:

  /* Default constructor */
  explicit NearestPointAlgorithmImplementationResult();

  /* Standard constructor */
  NearestPointAlgorithmImplementationResult(const Type::NumericalPoint & minimizer,
                                            const UnsignedLong iterationsNumber,
                                            const NumericalScalar absoluteError,
                                            const NumericalScalar relativeError,
                      	                    const NumericalScalar residualError,
              	                            const NumericalScalar constraintError);

  /* Copy constructor */
  NearestPointAlgorithmImplementationResult(const NearestPointAlgorithmImplementationResult & other);

  /* Virtual constructor */
  virtual NearestPointAlgorithmImplementationResult * clone() const;

  /* Destructor */
  virtual ~NearestPointAlgorithmImplementationResult();

  /* Minimizer accessors */
  Type::NumericalPoint getMinimizer() const;

  /* Iterations number accessor */
  UnsignedLong getIterationsNumber() const;

  /* Absolute error accessor */
  NumericalScalar getAbsoluteError() const;

  /* Relative error accessor */
  NumericalScalar getRelativeError() const;

  /* Residual error accessor */
  NumericalScalar getResidualError() const;

  /* Constraint error accessor */
  NumericalScalar getConstraintError() const;

  /* String converter */
  String __repr__() const;

}; // class NearestPointAlgorithmImplementationResult

%extend NearestPointAlgorithmImplementationResult {
  const String __str__() const { return self->__repr__(); }
}

}}}

namespace OpenTURNS{ namespace Base { namespace Optim { %extend NearestPointAlgorithmImplementation { NearestPointAlgorithmImplementation(const NearestPointAlgorithmImplementation & other) { return new OpenTURNS::Base::Optim::NearestPointAlgorithmImplementation(other); } } }}}
