//                                               -*- C++ -*-
/**
 *  @file  KissFFT.hxx
 *  @brief This class is enables to build an exponential covariance
 *  model, a second order model's implementation
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: KissFFT.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_KISSFFT_HXX
#define OPENTURNS_KISSFFT_HXX

#include "PersistentObject.hxx"
#include "FFTImplementation.hxx"


BEGIN_NAMESPACE_OPENTURNS

/**
 * @class KissFFT
 */

class KissFFT
  : public FFTImplementation
{

  CLASSNAME;

public:


  /** Default constructor without parameters */
  KissFFT(const String & name = DefaultName);

  /** Virtual copy constructor */
  KissFFT * clone() const;

  /** FFT transformation on complex */
  NumericalComplexCollection transform(const NumericalComplexCollection & collection) const;

  /** FFT transformation  with application on a block-part of the collection */
  NumericalComplexCollection transform(const NumericalComplexCollection & collection,
                                       const UnsignedLong first,
                                       const UnsignedLong size) const;

  /** FFT inverse transformation */
  NumericalComplexCollection inverseTransform(const NumericalComplexCollection & collection) const;

  /** FFT inverse transformation with application on a block-part of the collection */
  NumericalComplexCollection inverseTransform(const NumericalComplexCollection & collection,
                                              const UnsignedLong first,
                                              const UnsignedLong size) const;

  /** String converter */
  String __repr__() const;

  /** String converter */
  String __str__(const String & offset = "") const;

} ; /* class KissFFT */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_KISSFFT_HXX */
