//                                               -*- C++ -*-
/**
 *  @file  RandomDirection.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: RandomDirection.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "RandomDirection.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class RandomDirection
 */

CLASSNAMEINIT(RandomDirection);

/* Default constructor */
RandomDirection::RandomDirection():
  SamplingStrategyImplementation(0)
{
  // Nothing to do
}

/* Constructor with parameters */
RandomDirection::RandomDirection(const UnsignedLong dimension):
  SamplingStrategyImplementation(dimension)
{
  // Nothing to do
}

/* Virtual constructor */
RandomDirection * RandomDirection::clone() const
{
  return new RandomDirection(*this);
}

/* Generate a set of directions */
NumericalSample RandomDirection::generate() const
{
  NumericalSample result(2, dimension_);
  result[0] = getUniformUnitVectorRealization();
  result[1] = -1.0 * result[0];
  return result;
}

/* String converter */
String RandomDirection::__repr__() const
{
  OSS oss;
  oss << "class=" << RandomDirection::GetClassName()
      << " derived from " << SamplingStrategyImplementation::__repr__();
  return oss;
}

END_NAMESPACE_OPENTURNS

