//                                               -*- C++ -*-
/**
 *  @file  SamplingStrategyImplementation.hxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: SamplingStrategyImplementation.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_SAMPLINGSTRATEGYIMPLEMENTATION_HXX
#define OPENTURNS_SAMPLINGSTRATEGYIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "PersistentObject.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class SamplingStrategyImplementation
 */

class SamplingStrategyImplementation
  : public PersistentObject
{

  CLASSNAME;

public:

  /** Constructor with parameters */
  explicit SamplingStrategyImplementation(const UnsignedLong dimension);

  /** Virtual constructor */
  virtual SamplingStrategyImplementation * clone() const;

  /** Generate a set of directions */
  virtual NumericalSample generate() const;

  /** Generate a uniform random unit vector */
  NumericalPoint getUniformUnitVectorRealization(const UnsignedLong dimension) const;

  /** Generate a uniform random unit vector */
  NumericalPoint getUniformUnitVectorRealization() const;

  /** Dimension accessor */
  void setDimension(const UnsignedLong dimension);
  UnsignedLong getDimension() const;

  /** String converter */
  virtual String __repr__() const;

protected:

  UnsignedLong dimension_;

} ; /* class SamplingStrategyImplementation */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_SAMPLINGSTRATEGYIMPLEMENTATION_HXX */
