//                                               -*- C++ -*-
/**
 *  @file  TracyWidomGOE.cxx
 *  @brief The TracyWidomGOE distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: TracyWidomGOE.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include <cmath>
#include "TracyWidomGOE.hxx"
#include "RandomGenerator.hxx"
#include "Exception.hxx"
#include "PersistentObjectFactory.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(TracyWidomGOE);

static Factory<TracyWidomGOE> RegisteredFactory("TracyWidomGOE");


/* Default constructor */
TracyWidomGOE::TracyWidomGOE()
  : NonEllipticalDistribution("TracyWidomGOE")
{
  throw NotYetImplementedException(HERE);
  setDimension(1);
  setRange(Interval(-1.0, 1.0));
}

/* Comparison operator */
Bool TracyWidomGOE::operator ==(const TracyWidomGOE & other) const
{
  return true;
}

/* String converter */
String TracyWidomGOE::__repr__() const {
  OSS oss;
  oss << "class=" << TracyWidomGOE::GetClassName()
      << " name=" << getName()
      << " dimension=" << getDimension();
  return oss;
}

/* Virtual constructor */
TracyWidomGOE * TracyWidomGOE::clone() const
{
  return new TracyWidomGOE(*this);
}

/* Get the DDF of the distribution */
NumericalPoint TracyWidomGOE::computeDDF(const NumericalPoint & point) const
{
  throw NotYetImplementedException(HERE);
  NumericalScalar x(point[0]);
  if ((x <= -1.0) || (x > 1.0)) return NumericalPoint(1, 0.0);
  return NumericalPoint(1, -1.5 * x);
}


/* Get the PDF of the distribution */
NumericalScalar TracyWidomGOE::computePDF(const NumericalPoint & point) const
{
  throw NotYetImplementedException(HERE);
  NumericalScalar x(point[0]);
  if ((x <= -1.0) || (x > 1.0)) return 0.0;
  return 0.75 * (1.0 + x) * (1.0 - x);
}


/* Get the CDF of the distribution */
NumericalScalar TracyWidomGOE::computeCDF(const NumericalPoint & point, const Bool tail) const
{
  throw NotYetImplementedException(HERE);
  NumericalScalar x(point[0]);
  if (x <= -1.0) return (tail ? 1.0 : 0.0);
  if (x > 1.0) return (tail ? 0.0 : 1.0);
  if (tail) return 0.5 - x * (0.75 - 0.25 * x * x);
  return 0.5 + x * (0.75 - 0.25 * x * x);
}

/** Get the PDFGradient of the distribution */
NumericalPoint TracyWidomGOE::computePDFGradient(const NumericalPoint & point) const
{
  return NumericalPoint(0);
}

/** Get the CDFGradient of the distribution */
NumericalPoint TracyWidomGOE::computeCDFGradient(const NumericalPoint & point) const
{
  return NumericalPoint(0);
}

/* Get the quantile of the distribution */
NumericalScalar TracyWidomGOE::computeScalarQuantile(const NumericalScalar prob,
                                                     const Bool tail,
                                                     const NumericalScalar precision) const
{
  throw NotYetImplementedException(HERE);
  // 2.094395102393195492308429 = 2 * Pi / 3
  if (tail) return 2.0 * cos(0.3333333333333333333333333 * acos(2.0 * prob - 1.0) - 2.094395102393195492308429);
  return 2.0 * cos(0.3333333333333333333333333 * acos(1.0 - 2.0 * prob) - 2.094395102393195492308429);
}

/* Get the roughness, i.e. the L2-norm of the PDF */
NumericalScalar TracyWidomGOE::getRoughness() const
{
  throw NotYetImplementedException(HERE);
  return 0.6;
}

/* Compute the mean of the distribution */
void TracyWidomGOE::computeMean() const
{
  // RMT matlab toolbox computation
  mean_ = NumericalPoint(1, -1.2065335745820);
  isAlreadyComputedMean_ = true;
}

/* Get the standard deviation of the distribution */
NumericalPoint TracyWidomGOE::getStandardDeviation() const
{
  // RMT matlab toolbox computation
  return NumericalPoint(1, 1.607781034581);
}

/* Get the skewness of the distribution */
NumericalPoint TracyWidomGOE::getSkewness() const
{
  // RMT matlab toolbox computation
  return NumericalPoint(1, 0.29346452408);
}

/* Get the kurtosis of the distribution */
NumericalPoint TracyWidomGOE::getKurtosis() const
{
  // RMT matlab toolbox computation
  return NumericalPoint(1, 0.1652429384);
}

/* Compute the covariance of the distribution */
void TracyWidomGOE::computeCovariance() const
{
  covariance_ = CovarianceMatrix(1);
  const NumericalScalar sigma(getStandardDeviation()[0]);
  covariance_(0, 0) = sigma * sigma;
  isAlreadyComputedCovariance_ = true;
}

/* Parameters value and description accessor */
TracyWidomGOE::NumericalPointWithDescriptionCollection TracyWidomGOE::getParametersCollection() const
{
  // No parameter, return a collection with an empty NumericalPointWithDescription
  return NumericalPointWithDescriptionCollection(1, NumericalPointWithDescription(0));
}

/* Method save() stores the object through the StorageManager */
void TracyWidomGOE::save(Advocate & adv) const
{
  NonEllipticalDistribution::save(adv);
}

/* Method load() reloads the object from the StorageManager */
void TracyWidomGOE::load(Advocate & adv)
{
  NonEllipticalDistribution::load(adv);
}

END_NAMESPACE_OPENTURNS
