//                                               -*- C++ -*-
/**
 *  @file  t_KissFFT_std.cxx
 *  @brief The test file of class KissFFT
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy$
 *  @date:   $LastChangedDate$
 *  Id:      $Id$
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Normal.hxx"
#include "Distribution.hxx"
#include "PlatformInfo.hxx"
#include <cmath>

using namespace OT;
using namespace OT::Test;

typedef Collection<NumericalComplex> NumericalComplexCollection;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {

    // for fft, the best implementation is given for N = 2^p
    const UnsignedLong size(16);

    // collection for test
    NumericalComplexCollection collection(size);

    // Fill the data with artificial values

    // Create a complex gaussian sample
    for (UnsignedLong index = 0; index < size; ++index)
      {
        const NumericalScalar realPart( 0.1 * (1.0 + index) / size );
        const NumericalScalar imagPart( 0.3 * (1.0 + index) / size );
        collection[index] = NumericalComplex(realPart, imagPart);
      }

    /* Instanciation of FFT class */
    KissFFT myFFT;
    fullprint << "myFFT = " << myFFT << std::endl;

    // Initial transformation
    fullprint << "collection = " << collection << std::endl;

    // FFT transform
    const NumericalComplexCollection transformedCollection(myFFT.transform(collection));
    fullprint << "FFT result = " << transformedCollection << std::endl;

    // Inverse transformation
    const NumericalComplexCollection inverseTransformedCollection(myFFT.inverseTransform(transformedCollection));
    fullprint << "FFT back=" << inverseTransformedCollection << std::endl;


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
