//                                               -*- C++ -*-
/**
 *  @file  t_Library_cpp.cxx
 *  @brief The test file of class Library with C++ symbols
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_Library_cpp.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include <cstdlib>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "LibraryLoader.hxx"
#include "Library.hxx"

using namespace OT;
using namespace OT::Test;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    const String path(std::getenv("OPENTURNS_WRAPPER_PATH"));

    /** Instance creation */
    LibraryLoader & loader = LibraryLoader::GetInstance();

    try {
#ifndef WIN32
      String libraryPath1 = path + "/testwrapper_2.so";
#else
      String libraryPath1 = path + "\\testwrapper_2-0.dll";
#endif
      Library library = loader.load( libraryPath1.c_str() );
      fullprint << loader  << std::endl;
      fullprint << library << std::endl;

      OT::LibrarySymbol symbol = library.getSymbol("fonction2");
      fullprint << "Symbol found at address " << symbol << std::endl;


    }
    catch (DynamicLibraryException & ex) {
      throw TestFailed(ex.__repr__());
    }


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return OT::Test::ExitCode::Success;
}
