//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_exec.cxx
 *  @brief The test file of class NumericalMathFunction for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_NumericalMathFunction_exec_external.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include <string.h>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

#define ARGPFX "system="
  if (argc != 2) exit(1);
  if (strncmp(argv[1], ARGPFX, strlen(ARGPFX))) exit(1);

#define XMLPFX "poutre_external_"
#define XMLSIZE 256
  char filename[XMLSIZE] = XMLPFX;
  strncpy( filename + strlen(XMLPFX), argv[1] + strlen(ARGPFX), XMLSIZE - strlen(XMLPFX) );

  try {

    // Test basic functionnalities
    //checkClassWithClassName<ComputedNumericalMathEvaluationImplementation>();

    // Test some extra functionnalities
    //checkNameFeature<ComputedNumericalMathEvaluationImplementation>();


    /** Instance creation */
    NumericalMathFunction deviation( filename );

    NumericalPoint inPoint(4);
    inPoint[0] = 210.e9;
    inPoint[1] = 1000;
    inPoint[2] = 1.5;
    inPoint[3] = 2.e-6;

    NumericalPoint outPoint = deviation( inPoint );

    fullprint << "deviation = " << outPoint << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
