//                                               -*- C++ -*-
/**
 *  @file  t_RandomVector_constant.cxx
 *  @brief The test file of 'constant' RandomVector class
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-28 00:59:04 +0200 (Wed, 28 Mar 2012) $
 *  Id:      $Id: t_RandomVector_constant.cxx 2435 2012-03-27 22:59:04Z lebrun $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "ConstantRandomVector.hxx"
#include "RandomVector.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    /* We create a numerical point of dimension 4 */
    NumericalPoint point(4);
    const NumericalPoint & ref_point(point);

    point[0] = 101.0;
    point[1] = 102.0;
    point[2] = 103.0;
    point[3] = 104.0;

    fullprint << "point = " << ref_point << std::endl;

    /* We create a 'constant' RandomVector from the NumericalPoint */
    RandomVector vect = ConstantRandomVector(point);
    fullprint << "vect=" << vect << std::endl;

    /* Check standard methods of class RandomVector */
    fullprint << "vect dimension=" << vect.getDimension() << std::endl;
    fullprint << "vect realization (first )=" << vect.getRealization() << std::endl;
    fullprint << "vect realization (second)=" << vect.getRealization() << std::endl;
    fullprint << "vect realization (third )=" << vect.getRealization() << std::endl;
    fullprint << "vect sample =" << vect.getNumericalSample(5) << std::endl;

    /* We create a numerical point of dimension 4 */
    NumericalPointWithDescription pointWithDescription(4);
    pointWithDescription[0] = 101.0;
    pointWithDescription[1] = 102.0;
    pointWithDescription[2] = 103.0;
    pointWithDescription[3] = 104.0;
    Description description(4);
    description[0] = "x0";
    description[1] = "x1";
    description[2] = "x2";
    description[3] = "x3";
    pointWithDescription.setDescription(description);

    fullprint << "point with description= " << pointWithDescription << std::endl;

    /* We create a 'constant' RandomVector from the NumericalPoint */
    RandomVector vect2 = ConstantRandomVector(pointWithDescription);
    fullprint << "vect2=" << vect2 << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
