//                                               -*- C++ -*-
/**
 *  @file  t_ExponentialCauchy_std.cxx
 *  @brief The test file of class ExponentialCauchy
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: haddad $
 *  @date:   $LastChangedDate: 2011-11-22 12:09:10 +0100 (mar. 22 nov. 2011) $
 *  Id:      $Id: t_ExponentialCauchy_std.cxx 2209 2011-11-22 11:09:10Z haddad $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "UserDefinedSpectralModel.hxx"

using namespace OT;
using namespace OT::Test;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try
    {
      // Dimension of the input model
      // Size of the TimeGrid
      UnsignedLong size(64);
      UnsignedLong dimension(1);
      RegularGrid timeGrid(0.0, 0.1, size);
      NumericalPoint amplitude(dimension, 2.0);
      NumericalPoint scale(dimension, 1.0);
      ExponentialCauchy model(amplitude, scale);
      SpectralNormalProcess myProcess(model, timeGrid);

      // Create a Process sample
      UnsignedLong N(100);
      ProcessSample sample(myProcess.getSample(N));

      // Filtering Windows
      WelchFactory myFactory;

      // Build a UserDefinedSpectralModel using the Wellch method
      SpectralModel mySpectralModel(myFactory.build(sample));

      // Get the frequency grid of the model
      RegularGrid myFrequencyGrid(mySpectralModel.getFrequencyGrid());
      for (UnsignedLong i = 0 ; i < dimension ; ++i)
        {
          for (UnsignedLong j = 0 ; j < dimension ; ++j)
            {
              fullprint << "Spectre " << i << "-" << j << std::endl;
              for (UnsignedLong k = 0; k < myFrequencyGrid.getN(); ++k)
                {
                  const NumericalScalar frequency(myFrequencyGrid.getStart() + k * myFrequencyGrid.getStep());
                  const NumericalScalar estimatedValue(std::real(mySpectralModel.computeSpectralDensity(frequency)(i,j)));
                  const NumericalScalar modelValue(std::real(model.computeSpectralDensity(frequency)(i,j)));
                  fullprint << "Frequency =  " <<  frequency ;
                  fullprint << ", evaluation = " << estimatedValue << " model = " << modelValue << std::endl;
                }
            }
        }
      // Create a Time Series
      TimeSeries timeSeries(myProcess.getRealization());

      // Build a UserDefinedSpectralModel using the Wellch method
      SpectralModel mySpectralModel2(myFactory.build(timeSeries));

      // Get the frequency grid of the model
      myFrequencyGrid = mySpectralModel2.getFrequencyGrid();
      for (UnsignedLong i = 0 ; i < dimension ; ++i)
        {
          for (UnsignedLong j = 0 ; j < dimension ; ++j)
            {
              fullprint << "Spectre " << i << "-" << j << std::endl;
              for (UnsignedLong k = 0; k < myFrequencyGrid.getN(); ++k)
                {
                  const NumericalScalar frequency(myFrequencyGrid.getStart() + k * myFrequencyGrid.getStep());
                  const NumericalScalar estimatedValue(std::real(mySpectralModel2.computeSpectralDensity(frequency)(i,j)));
                  const NumericalScalar modelValue(std::real(model.computeSpectralDensity(frequency)(i,j)));
                  fullprint << "Frequency =  " <<  frequency ;
                  fullprint << ", evaluation = " << estimatedValue << " model = " << modelValue << std::endl;
                }
            }
        }
    }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
