//                                               -*- C++ -*-
/**
 *  @file  OTSimulation.hxx
 *  @brief The external header file of Open TURNS for subdir Simulation
 *
 *  Copyright (C) 2005-2014 Airbus-EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author dutka
 *  @date   2009-02-11 16:49:59 +0100 (Wed, 11 Feb 2009)
 */

#ifndef OPENTURNS_OTSIMULATION_HXX
#define OPENTURNS_OTSIMULATION_HXX

#include "DirectionalSampling.hxx"
#include "RootStrategy.hxx"
#include "RootStrategyImplementation.hxx"
#include "RiskyAndFast.hxx"
#include "MediumSafe.hxx"
#include "SafeAndSlow.hxx"
#include "SamplingStrategy.hxx"
#include "SamplingStrategyImplementation.hxx"
#include "RandomDirection.hxx"
#include "OrthogonalDirection.hxx"
#include "ImportanceSampling.hxx"
#include "LHS.hxx"
#include "RandomizedLHS.hxx"
#include "MonteCarlo.hxx"
#include "PostAnalyticalControlledImportanceSampling.hxx"
#include "PostAnalyticalImportanceSampling.hxx"
#include "PostAnalyticalSimulation.hxx"
#include "QuasiMonteCarlo.hxx"
#include "RandomizedQuasiMonteCarlo.hxx"
#include "QuasiMonteCarloResult.hxx"
#include "Simulation.hxx"
#include "SimulationResult.hxx"
#include "SimulationResultImplementation.hxx"
#include "SimulationSensitivityAnalysis.hxx"
#include "Wilks.hxx"

#endif /* OPENTURNS_OTSIMULATION_HXX */
