//                                               -*- C++ -*-
/**
 *  @file  t_Pairs_std.cxx
 *  @brief The test file of class Pairs for standard methods
 *
 *  Copyright (C) 2005-2014 Airbus-EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author lebrun
 *  @date   2011-02-26 21:12:17 +0100 (sam. 26 févr. 2011)
 */
#include "OT.hxx"
#include "OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try
  {

    // Instanciate one distribution object
    UnsignedLong dim(5);
    NumericalPoint meanPoint(dim, 0.0);
    NumericalPoint sigma(dim, 5.0);
    CorrelationMatrix R(dim);

    Normal distribution(meanPoint, sigma, R);

    // Instanciate another distribution object
    for (UnsignedLong i = 1; i < dim; i++) R(i, i - 1) = -0.25;

    // Test for sampling
    UnsignedLong size = 1000;
    NumericalSample sample(distribution.getSample( size ));

    // Create an empty graph
    Graph myGraph("Pairs", " ", " ", true, "topright");

    // Create the first cloud
    Pairs myPairs(sample, "Pairs example", sample.getDescription(), "green", "bullet");

    // Then, draw it
    myGraph.add(Drawable(myPairs));
    myGraph.draw("Graph_Pairs_OT");

    // Check that the correct files have been generated by computing their checksum
    fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << myGraph.getPostscript() << std::endl;
  }
  catch (TestFailed & ex)
  {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
