#include <glib.h>
#include "everything-impl.hh"
#include "everything-cpp-stubs.hh"
#include "constants.hh"
#include <iostream>
using namespace std;


// TestFactory_impl --------------------------------------------------------------


test_impl::TestFactory_impl *
test_impl::TestFactory_impl::m_instance = NULL;

test::TestFactory_ptr
test_impl::TestFactory_impl::m_instancePtr = test::TestFactory::_nil();


test::TestFactory_ptr
test_impl::TestFactory_impl::instance(){
	if (m_instancePtr == test::TestFactory::_nil()){
		m_instance = new test_impl::TestFactory_impl;
		m_instancePtr = m_instance->_this();
	}
	return test::TestFactory::_duplicate(m_instancePtr);
}


test_impl::TestFactory_impl::TestFactory_impl()
	:m_basicServerRef(m_basicServer._this()),
	 m_structServerRef(m_structServer._this()),
	 m_sequenceServerRef(m_sequenceServer._this()),
	 m_baseServerRef(m_baseServer._this()),
     m_derivedServerRef(m_derivedServer._this()),
	 m_unionServerRef(m_unionServer._this()),
	 m_anyServerRef(m_anyServer._this())
{
}



test::BasicServer_ptr
test_impl::TestFactory_impl::getBasicServer() throw (CORBA::SystemException){
  return test::BasicServer::_duplicate(m_basicServerRef);
}

test::StructServer_ptr
test_impl::TestFactory_impl::getStructServer() throw (CORBA::SystemException){
  return test::StructServer::_duplicate(m_structServerRef);
}

test::SequenceServer_ptr
test_impl::TestFactory_impl::getSequenceServer() throw (CORBA::SystemException){
  return test::SequenceServer::_duplicate(m_sequenceServerRef);
}

test::BaseServer_ptr
test_impl::TestFactory_impl::getBaseServer() throw (CORBA::SystemException){
  return test::BaseServer::_duplicate(m_baseServerRef);
}

test::DerivedServer_ptr
test_impl::TestFactory_impl::getDerivedServer() throw (CORBA::SystemException){
  return test::DerivedServer::_duplicate(m_derivedServerRef);
}

test::BaseServer_ptr
test_impl::TestFactory_impl::getDerivedServerAsBaseServer() throw (CORBA::SystemException){
  return test::DerivedServer::_duplicate(m_derivedServerRef);
}

test::B2_ptr
test_impl::TestFactory_impl::getDerivedServerAsB2() throw (CORBA::SystemException){
  return test::DerivedServer::_duplicate(m_derivedServerRef);
}


test::TransientObj_ptr
test_impl::TestFactory_impl::createTransientObj() throw (CORBA::SystemException){
  test_impl::TransientObj_impl *impl = new test_impl::TransientObj_impl;
  test::TransientObj_ptr ptr = impl->_this();   // the poa calls _add_ref() implicitly
  
  PortableServer::POA_var rootPOA = _default_POA();

  // check that reference_to_servant works
  PortableServer::Servant s1 = impl;
  PortableServer::Servant s2 = rootPOA->reference_to_servant(ptr);  
  g_assert (s1 == s2);
  
  impl->_remove_ref();   // release the servant since we are finished with it
  return ptr;
}

test::UnionServer_ptr
test_impl::TestFactory_impl::getUnionServer() throw (CORBA::SystemException){
  return test::UnionServer::_duplicate(m_unionServerRef);
}

test::AnyServer_ptr
test_impl::TestFactory_impl::getAnyServer() throw (CORBA::SystemException){
  return test::AnyServer::_duplicate(m_anyServerRef);
}


// BasicServer_impl --------------------------------------------------------------

char*
test_impl::BasicServer_impl::foo() throw (CORBA::SystemException) {
	return CORBA::string_dup(constants::STRING_RETN);
}

void
test_impl::BasicServer_impl::foo(const char *val) throw (CORBA::SystemException) {
	g_assert(strcmp(val,constants::STRING_IN)==0);
}

CORBA::Long
test_impl::BasicServer_impl::bah() throw (CORBA::SystemException) {
	return constants::LONG_RETN;
}

char*
test_impl::BasicServer_impl::opString(const char* inArg,
									  char*& inoutArg,
									  CORBA::String_out outArg) throw (CORBA::SystemException){
  g_assert(strcmp(inArg,constants::STRING_IN)==0);
  g_assert(strcmp(inoutArg,constants::STRING_INOUT_IN)==0);

  CORBA::string_free(inoutArg);
  inoutArg = CORBA::string_dup(constants::STRING_INOUT_OUT);
  outArg = CORBA::string_dup(constants::STRING_OUT);
  return CORBA::string_dup(constants::STRING_RETN);  
}

CORBA::Long
test_impl::BasicServer_impl::opLong(const CORBA::Long inArg, 
									CORBA::Long& inoutArg, 
									CORBA::Long& outArg) throw (CORBA::SystemException) {
  g_assert(inArg == constants::LONG_IN);
  g_assert(inoutArg == constants::LONG_INOUT_IN);
  
  inoutArg = constants::LONG_INOUT_OUT;
  outArg = constants::LONG_OUT;;
  return constants::LONG_RETN;
}

void
test_impl::BasicServer_impl::opException()  throw (CORBA::SystemException, test::TestException) {

//	test::TestException ex("This is a test",42,{25,55});
	test::TestException ex;
	ex.reason = constants::STRING_IN;
	ex.number = constants::LONG_IN;
	ex.aseq.length(1);
	ex.aseq[0] = constants::LONG_IN;
	ex.factory = test_impl::TestFactory_impl::instance();
	
	throw ex;
}

test::AnEnum
test_impl::BasicServer_impl::opEnum(test::AnEnum inArg,
									test::AnEnum& inoutArg,
									test::AnEnum& outArg) throw (CORBA::SystemException){
  g_assert(inArg == test::ENUM_IN);
  g_assert(inoutArg == test::ENUM_INOUT_IN);
  
  inoutArg = test::ENUM_INOUT_OUT;
  outArg = test::ENUM_OUT;
  return test::ENUM_RETN;
}

test::LongArray_slice *
test_impl::BasicServer_impl::opLongArray(const test::LongArray inArg,
										 test::LongArray inoutArg,
										 test::LongArray_out outArg) throw (CORBA::SystemException){
	for(int i=0;i<constants::SEQLEN;i++)
		g_assert(inArg[i]==constants::SEQ_LONG_IN[i]);
	for(int i=0;i<constants::SEQLEN;i++)
		g_assert(inoutArg[i]==constants::SEQ_LONG_INOUT_IN[i]);
	
	test::LongArray_copy(inoutArg,constants::SEQ_LONG_INOUT_OUT);
	test::LongArray_copy(outArg,constants::SEQ_LONG_OUT);
	test::LongArray_slice *retn = test::LongArray_dup(constants::SEQ_LONG_RETN);
	
	return retn;
}


test::StrArray_slice *
test_impl::BasicServer_impl::opStrArray(const test::StrArray inArg,
										test::StrArray inoutArg,
										test::StrArray_out outArg) throw (CORBA::SystemException) {
  for(int i=0;i<constants::SEQLEN;i++)
	g_assert(strcmp(inArg[i],constants::SEQ_STRING_IN[i])==0);

  for(int i=0;i<constants::SEQLEN;i++)
	g_assert(strcmp(inoutArg[i],constants::SEQ_STRING_INOUT_IN[i])==0);

  test::StrArray_copy(inoutArg,reinterpret_cast<test::StrArray_slice const *>(constants::SEQ_STRING_INOUT_OUT));  

  outArg =
	test::StrArray_dup(reinterpret_cast<test::StrArray_slice const *>(constants::SEQ_STRING_OUT));
  test::StrArray_slice *retn =
	test::StrArray_dup(reinterpret_cast<test::StrArray_slice const *>(constants::SEQ_STRING_RETN));
  
  return retn;
}


// StructServer_impl --------------------------------------------------------------

::test::FixedLengthStruct
test_impl::StructServer_impl::opFixed(const ::test::FixedLengthStruct &inArg,
									  ::test::FixedLengthStruct &inoutArg,
									  ::test::FixedLengthStruct_out outArg) throw (CORBA::SystemException){
	g_assert(inArg.a == constants::SHORT_IN);
	g_assert(inoutArg.a == constants::SHORT_INOUT_IN);

	inoutArg.a = constants::SHORT_INOUT_OUT;
	outArg.a = constants::SHORT_OUT;
	test::FixedLengthStruct retval;
	retval.a = constants::SHORT_RETN;
	return retval;
}

::test::VariableLengthStruct*
test_impl::StructServer_impl::opVariable(const ::test::VariableLengthStruct &inArg,
										 ::test::VariableLengthStruct &inoutArg,
										 ::test::VariableLengthStruct_out outArg) throw (CORBA::SystemException) {
	g_assert(strcmp(inArg.a,constants::STRING_IN) == 0);
	g_assert(strcmp(inoutArg.a,constants::STRING_INOUT_IN)==0);

	outArg = new test::VariableLengthStruct;
	test::VariableLengthStruct *retval = new test::VariableLengthStruct;
	
	inoutArg.a = CORBA::string_dup(constants::STRING_INOUT_OUT);
	outArg->a = CORBA::string_dup(constants::STRING_OUT);
	retval->a = CORBA::string_dup(constants::STRING_RETN);

	return retval;
}

::test::CompoundStruct*
test_impl::StructServer_impl::opCompound(const ::test::CompoundStruct &inArg,
										 ::test::CompoundStruct &inoutArg,
										 ::test::CompoundStruct_out outArg) throw (CORBA::SystemException) {
	g_assert(strcmp(inArg.a.a,constants::STRING_IN) == 0);
	g_assert(strcmp(inoutArg.a.a,constants::STRING_INOUT_IN)==0);

	outArg = new test::CompoundStruct;
	test::CompoundStruct *retval = new test::CompoundStruct;
	
	inoutArg.a.a = CORBA::string_dup(constants::STRING_INOUT_OUT);
	outArg->a.a = CORBA::string_dup(constants::STRING_OUT);
	retval->a.a = CORBA::string_dup(constants::STRING_RETN);

	return retval;
}


// SequenceServer_impl --------------------------------------------------------------
test::StrSeq *
test_impl::SequenceServer_impl::opStrSeq(const test::StrSeq &inArg,
										 test::StrSeq &inoutArg,
										 test::StrSeq_out outArg) throw (CORBA::SystemException) {

	for (guint i=0;i<inArg.length();i++){
		g_assert(strcmp(inArg[i],constants::SEQ_STRING_IN[i]) == 0);
	}
  
	for (guint i=0;i<inoutArg.length();i++){
		g_assert(strcmp(inoutArg[i],constants::SEQ_STRING_INOUT_IN[i]) == 0);
	}
  
	inoutArg.length(2);
	for (guint i=0;i<inoutArg.length();i++)
		inoutArg[i] = constants::SEQ_STRING_INOUT_OUT[i];

	outArg = new test::StrSeq;
	outArg->length(2);
	for (guint i=0;i<outArg->length();i++)
		(*outArg)[i] = CORBA::string_dup(constants::SEQ_STRING_OUT[i]);

  
	test::StrSeq* retn = new test::StrSeq;
	retn->length(2);
	for (guint i=0;i<retn->length();i++)
		(*retn)[i] = CORBA::string_dup(constants::SEQ_STRING_RETN[i]);

	return retn;
}

test::BoundedStructSeq *
test_impl::SequenceServer_impl::opBoundedStructSeq(const test::BoundedStructSeq &inArg,
												   test::BoundedStructSeq &inoutArg,
												   test::BoundedStructSeq_out outArg) throw (CORBA::SystemException) {
	for (guint i=0;i<inArg.length();i++)
		g_assert(strcmp(inArg[i].a.a,constants::SEQ_STRING_IN[i])==0);

	for (guint i=0;i<inoutArg.length();i++)
		g_assert(strcmp(inoutArg[i].a.a,constants::SEQ_STRING_INOUT_IN[i])==0);

	outArg = new test::BoundedStructSeq;
	outArg->length(2);
	test::BoundedStructSeq *retval =new test::BoundedStructSeq;
	retval->length(2);

	for (guint i=0;i<inoutArg.length();i++)
		inoutArg[i].a.a = constants::SEQ_STRING_INOUT_OUT[i];
	
	for (guint i=0;i<outArg->length();i++)
		outArg[i].a.a = constants::SEQ_STRING_OUT[i];
	
	for (guint i=0;i<retval->length();i++)
		(*retval)[i].a.a = constants::SEQ_STRING_RETN[i];

	return retval;
}

// BaseServer_impl --------------------------------------------------------------

CORBA::Long
test_impl::BaseServer_impl::opPolymorphic() throw (CORBA::SystemException){
	return constants::LONG_BASE;
}

char *
test_impl::BaseServer_impl::attribPolymorphic() throw (CORBA::SystemException) {
	return CORBA::string_dup(constants::STRING_BASE);
}

void
test_impl::BaseServer_impl::attribPolymorphic(const char *val) throw (CORBA::SystemException) {
	g_assert(strcmp(val,constants::STRING_BASE)==0);
}


// DerivedServer_impl --------------------------------------------------------------
test_impl::DerivedServer_impl::DerivedServer_impl() {
	m_state = constants::LONG_DERIVED;
}

CORBA::Long
test_impl::DerivedServer_impl::opPolymorphic() throw (CORBA::SystemException) {
	return m_state;
}

char *
test_impl::DerivedServer_impl::attribPolymorphic() throw (CORBA::SystemException) {
	return CORBA::string_dup(constants::STRING_DERIVED);
}

void
test_impl::DerivedServer_impl::attribPolymorphic(const char *val) throw (CORBA::SystemException) {
	g_assert(strcmp(val,constants::STRING_DERIVED)==0);
	g_assert(m_state == constants::LONG_DERIVED);
	
}


// TransientObj_impl --------------------------------------------------------------
void
test_impl::TransientObj_impl::remove() throw (CORBA::SystemException) {
  PortableServer::POA_var poa = _default_POA();
  PortableServer::ObjectId_var oid = poa->servant_to_id(this);
  //PortableServer::ObjectId* oidp = poa->servant_to_id(this);
  poa->deactivate_object(oid);
  //  delete oidp;
  _remove_ref(); // should we be calling this?
}

// UnionServer_impl --------------------------------------------------------------

::test::FixedLengthUnion
test_impl::UnionServer_impl::opFixed(const ::test::FixedLengthUnion &inArg,
									  ::test::FixedLengthUnion &inoutArg,
									  ::test::FixedLengthUnion_out outArg) throw (CORBA::SystemException) {
	g_assert(inArg._d() == 'a');
	g_assert(inArg.x() == constants::LONG_IN);

	g_assert(inoutArg._d() == 'b');
	g_assert(inoutArg.y() == 't');

	inoutArg.z(true);
	inoutArg._d('c');
	outArg.x(constants::LONG_OUT);
	test::FixedLengthUnion retval;
	retval.z(false);
	retval._d('d');
	return retval;
}


::test::VariableLengthUnion*
test_impl::UnionServer_impl::opVariable(const ::test::VariableLengthUnion &inArg,
									  ::test::VariableLengthUnion &inoutArg,
									  ::test::VariableLengthUnion_out outArg) throw (CORBA::SystemException) {
	g_assert(inArg._d() == 1);
	g_assert(inArg.x() == constants::LONG_IN);

	g_assert(inoutArg._d() == 2);
	g_assert(strcmp(inoutArg.y(),constants::STRING_INOUT_IN)==0);

	inoutArg.z(true);
	inoutArg._d(3);
	outArg = new test::VariableLengthUnion;
	outArg->x(constants::LONG_OUT);
	test::VariableLengthUnion *retval = new test::VariableLengthUnion;
	retval->z(false);
	retval->_d(4);
	return retval;
}


// AnyServer_impl --------------------------------------------------------------

CORBA::Any *
test_impl::AnyServer_impl::opAnyLong(const CORBA::Any &inArg,
								   CORBA::Any &inoutArg,
								   CORBA::Any_out outArg) throw (CORBA::SystemException) {
	CORBA::Long l;
	g_assert(inArg>>= l);
	g_assert(l == constants::LONG_IN);

	g_assert(inoutArg>>= l);
	g_assert(l == constants::LONG_INOUT_IN);
	inoutArg <<= constants::LONG_INOUT_OUT;

	outArg = new CORBA::Any;
	(*outArg) <<= constants::LONG_OUT;
	
	CORBA::Any *retn = new CORBA::Any;
	(*retn)<<= constants::LONG_RETN;
	return retn;
}

CORBA::Any *
test_impl::AnyServer_impl::opAnyString(const CORBA::Any &inArg,
									   CORBA::Any &inoutArg,
									   CORBA::Any_out outArg) throw (CORBA::SystemException) {
	const char *s;
	g_assert(inArg>>= s);
	g_assert(strcmp(s,constants::STRING_IN)==0);

	g_assert(inoutArg>>= s);
	g_assert(strcmp(s,constants::STRING_INOUT_IN)==0);
	inoutArg <<= constants::STRING_INOUT_OUT;

	outArg = new CORBA::Any;
	(*outArg) <<= constants::STRING_OUT;
	
	CORBA::Any *retn = new CORBA::Any;
	(*retn)<<= constants::STRING_RETN;
	return retn;
}

CORBA::Any *
test_impl::AnyServer_impl::opAnyStruct(const CORBA::Any &inArg,
									   CORBA::Any &inoutArg,
									   CORBA::Any_out outArg) throw (CORBA::SystemException) {

	const test::VariableLengthStruct *s;
  
	g_assert(inArg>>= s);
	g_assert(strcmp(s->a,constants::STRING_IN) == 0);
	g_assert(inoutArg>>= s);
	g_assert(strcmp(s->a,constants::STRING_INOUT_IN)==0);

	test::VariableLengthStruct inoutArgStruct;
	test::VariableLengthStruct outArgStruct;
	test::VariableLengthStruct retvalStruct;
	
	inoutArgStruct.a = constants::STRING_INOUT_OUT;
	outArgStruct.a = constants::STRING_OUT;
	retvalStruct.a = constants::STRING_RETN;
	
	outArg = new CORBA::Any;
	CORBA::Any *retval = new CORBA::Any;

	inoutArg <<= inoutArgStruct;
	(*outArg) <<= outArgStruct;
	(*retval) <<= retvalStruct;
	return retval;
}

CORBA::TypeCode_ptr
test_impl::AnyServer_impl::opTypeCode(CORBA::TypeCode_ptr inArg,
									  CORBA::TypeCode_ptr &inoutArg,
									  CORBA::TypeCode_out outArg) throw (CORBA::SystemException) {
	g_assert(inArg->equal(test::_tc_ArrayUnion));
	g_assert(inoutArg->equal(test::_tc_AnyServer));

	_orbitcpp::CEnvironment ev;
	CORBA_Object_release((CORBA_Object)inoutArg,ev);

	//CORBA::release(inoutArg);
  	inoutArg=CORBA::TypeCode::_duplicate(test::_tc_TestException);
	//	outArg = CORBA::TypeCode::_duplicate(test::_tc_AnEnum);
	outArg = test::_tc_AnEnum;
	return test::_tc_VariableLengthStruct; 
}
