/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "EllipsoidVolPy.h"

using namespace boost::python;

    void exportEllipsoidVol()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<EllipsoidVol, bases<AVolume3D> >(
        "EllipsoidVol",
        "A class defining an ellipsoidal volume in 3D. Major axes are axis-aligned.",
        init<>()
      )
      .def(init<const EllipsoidVol &>())
      .def(
        init<Vector3,double,double,double>(
          ( arg("centre"), arg("Lx"), arg("Ly"), arg("Lz") ),
          "Constructs an ellipsoid with the specified centre and axis-aligned lengths. WARNING: The surface particles are not fitted to the ellipsoid surface, resulting in blob-like particle clusters.\n"
          "@type centre: L{Vector3}\n"
          "@kwarg centre: Coordinates of the centre of the ellipsoid\n"
          "@type Lx: double\n"
          "@kwarg Lx: Length of ellipsoid major axis in x-direction\n"
          "@type Ly: double\n"
          "@kwarg Ly: Length of ellipsoid major axis in y-direction\n"
          "@type Lz: double\n"
          "@kwarg Lz: Length of ellipsoid major axis in z-direction\n"
        )
      )
      .def(self_ns::str(self))
      ;
    }



