/***************************************************************************
 *   Copyright (C) 2008-2010 by fra74                                           *
 *   francesco.b74@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "utils.h"

//funzioni varie per il debug dei nodi DOM
QString dumpNodo(QDomNode nodo)
{
	QString temp;
	QTextStream stream(&temp, QIODevice::WriteOnly);
	nodo.save(stream, 3);
	return temp;
}

void debugNodo(QDomNode nodo)
{
	QMessageBox msg;
	msg.setTextFormat(Qt::PlainText);
	msg.setText(dumpNodo(nodo));
	msg.exec();
}

void debugStringa(QString stringa)
{
	QMessageBox msg;
	msg.setTextFormat(Qt::PlainText);
	msg.setText(stringa);
	msg.exec();
}

//corregge alcuni errori nel codice XHTML generato da viaggiatreno che ne impediscono
//il corretto parsing da parte della classe QDom
//TODO: da rimuovere quando in tutte le schede si utilizzerà il nuovo sistema centralizzato di download
//la classe DownloadViaggiaTreno ha un metodo analogo
QString correggiOutputVT(QString testoVT)
{
	//effettua alcune sostituzione nel codice XHTML generato da ViaggiaTreno, che NON è valido
	//sostituisci <br> con <br/>
	QString temp = testoVT.simplified();
	//sostutuisce l'entità per gli accenti....
	temp.replace("&#039;", "'");
	//sostituisce gli ampersend negli URL con &amp;
	temp.replace("&", "&amp;");
	// sostituisce <br> con <br/>
	temp.replace("<br>", "<br/>");
	temp.replace("</strong> <br/> <br/>", "</strong> </p> <br/>");

	return temp;
}
