\name{checkWarning}
\alias{checkWarning}
\title{Extra Check Functions for RUnit}
\usage{
  checkWarning(expr, expected = TRUE, msg = NULL)
}
\arguments{
  \item{expr}{an R expression}

  \item{expected}{expected value as regular expression
  pattern. If a logical, then it specifies if a warning is
  expected or not.

  For backward compatibility, a \code{NULL} value is
  equivalent to \code{TRUE}.}

  \item{msg}{informative message to add to the error in
  case of failure}
}
\description{
  \code{checkWarning} checks if a warning is generated by
  an expression, and optionally follows an expected regular
  expression pattern.
}
\examples{
\dontshow{# roxygen generated flag
options(R_CHECK_RUNNING_EXAMPLES_=TRUE)
}

# check warnings
checkWarning({ warning('ah ah'); 3})
checkWarning({ warning('ah oh ah'); 3}, 'oh')
try( checkWarning(3) )
try( checkWarning({ warning('ah ah'); 3}, 'warn you') )
}

