/*
RealTimeBattle, a robot programming game for Unix
Copyright (C) 1998-2000  Erik Ouchterlony and Ragnar Ouchterlony

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*/

#ifndef __ROBOTOPTIONTYPE__
#define __ROBOTOPTIONTYPE__

/**
* Namespace Parser
*/
namespace Parser {
	enum robot_option_type
	{
	  SIGNAL=2,                   // 0 - no signal, > 1 - signal to send (e.g. SIGUSR1 or SIGUSR2) 
	  SEND_SIGNAL=0,              // 0 - false, 1 - true
	  SEND_ROTATION_REACHED=1,    // 0 - no messages
				      // 1 - messages when RotateTo and RotateAmount finished
				      // 2 - messages also when sweep direction is changed

	  USE_NON_BLOCKING=3          // 0 - false, 1 - true 
				      // This option should always be sent as soon as possible

	};
}

#endif 
