#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc LineDialog {frame id} {
    global menu
    global marker
    global ds9

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # init marker variables

    set marker($frame,$id,system) $marker(dialog,system)
    set marker($frame,$id,clabel) $marker(dialog,system)
    set marker($frame,$id,sky) $marker(dialog,sky)
    set marker($frame,$id,skyformat) $marker(dialog,skyformat)

    set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    set marker($frame,$id,dlabel) $marker(dialog,dist,system)
    set marker($frame,$id,dformat) $marker(dialog,dist,format)

    # arrows

    set arrows [$frame get marker $id line arrow]
    set marker($frame,$id,p1arrow) [lindex $arrows 0]
    set marker($frame,$id,p2arrow) [lindex $arrows 1]

    # line specific callbacks

    $frame marker $id callback move EditLineCB $frame
    $frame marker $id callback edit EditLineCB $frame
    $frame marker $id callback text TextMarkerCB $frame
    $frame marker $id callback color ColorMarkerCB $frame
    $frame marker $id callback width LineWidthMarkerCB $frame
    $frame marker $id callback property PropertyMarkerCB $frame
    $frame marker $id callback font FontMarkerCB $frame
    $frame marker $id callback delete DeleteLineDialog $frame

    # define menus

    MBMarkerDialog $frame $mb
    FileMenuMarkerDialog $frame $mb $id
    ColorMenuMarkerDialog $frame $mb $id
    WidthMenuMarkerDialog $frame $mb $id
    PropMenuLineDialog $frame $mb $id
    FontMenuMarkerDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordLineCB
    DistMenuMarkerDialog $frame $mb $id DistLineCB dist dcoord dformat
    $mb add cascade -label Distance -menu $mb.dist

    # Init line variables

    EditLineCB $frame $id
    TextMarkerCB $frame $id
    ColorMarkerCB $frame $id
    LineWidthMarkerCB $frame $id
    PropertyMarkerCB $frame $id
    FontMarkerCB $frame $id
    CoordMarkerCB $frame $id
    DistLineCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyLineDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "CloseLineDialog $frame $id"

    # create window

    set type [string toupper "[$frame get marker $id type]"]

    toplevel $w -colormap $ds9(main)
    wm title $w $type
    wm iconname $w $type
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW "CloseLineDialog $frame $id"

    $w configure -menu $mb

    # Dialog

    frame $w.basic -relief groove -borderwidth 2
    frame $w.basic.f
    frame $w.ref -relief groove -borderwidth 2
    frame $w.ref.f
    frame $w.dist -relief groove -borderwidth 2
    frame $w.dist.f
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.basic.f $w.ref.f $w.dist.f -anchor w -padx 4 -pady 4
    pack $w.basic $w.ref $w.dist -fill x 
    pack $w.buttons -fill x -ipadx 4 -ipady 4

    # ID

    label $w.basic.f.idTitle -text "Id"
    label $w.basic.f.idValue -text "$id"

    # Text

    label $w.basic.f.textTitle -text "Text"
    entry $w.basic.f.textValue -textvariable marker($frame,$id,text) -width 40

    grid $w.basic.f.idTitle $w.basic.f.idValue -padx 4 -sticky w
    grid $w.basic.f.textTitle $w.basic.f.textValue -padx 4 -sticky w

    # Points

    label $w.ref.f.title -text "Points"
    entry $w.ref.f.x -textvariable marker($frame,$id,x) -width 13
    entry $w.ref.f.y -textvariable marker($frame,$id,y) -width 13
    checkbutton $w.ref.f.p1arrow -variable marker($frame,$id,p1arrow) \
	-text "Arrow" -command "ArrowLineDialog $frame $id"
    label $w.ref.f.coord -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,clabel)
    entry $w.ref.f.x2 -textvariable marker($frame,$id,x2) -width 13
    entry $w.ref.f.y2 -textvariable marker($frame,$id,y2) -width 13
    checkbutton $w.ref.f.p2arrow -variable marker($frame,$id,p2arrow) \
	-text "Arrow" -command "ArrowLineDialog $frame $id"

    grid $w.ref.f.title $w.ref.f.x $w.ref.f.y $w.ref.f.p1arrow $w.ref.f.coord \
	-padx 4 -sticky w
    grid x $w.ref.f.x2 $w.ref.f.y2 $w.ref.f.p2arrow -padx 4 -sticky w

    # Length

    label $w.dist.f.title -text "Length"
    label $w.dist.f.dist -relief groove -width 12 -padx 4 \
	-textvariable marker($frame,$id,dist)
    label $w.dist.f.format -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,dlabel)

    grid $w.dist.f.title $w.dist.f.dist $w.dist.f.format -padx 4 -sticky w

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyLineDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "CloseLineDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyLineDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc PropMenuLineDialog {frame mb id} {
    global menu
    global marker

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Edit" \
	-variable marker($frame,$id,edit) \
	-command "PropertyMarkerDialog $frame $id edit"
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "PropertyMarkerDialog $frame $id move"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "PropertyMarkerDialog $frame $id delete"
    $mb.properties add separator
    $mb.properties add radiobutton -label Include \
	-variable marker($frame,$id,include) -value 1 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add radiobutton -label Exclude \
	-variable marker($frame,$id,include) -value 0 \
	-command "PropertyMarkerDialog $frame $id include"
    $mb.properties add separator
    $mb.properties add radiobutton -label Source \
	-variable marker($frame,$id,source) -value 1 \
	-command "PropertyMarkerDialog $frame $id source"
    $mb.properties add radiobutton -label Background \
	-variable marker($frame,$id,source) -value 0 \
	-command "PropertyMarkerDialog $frame $id source"
}

proc ApplyLineDialog {frame id} {
    global marker

    EditLineDialog $frame $id
    $frame marker $id text \{$marker($frame,$id,text)\}

    UpdateMarkerMenu
}

proc CloseLineDialog {frame id} {
    global marker

    $frame marker $id delete callback edit EditLineCB
    $frame marker $id delete callback move EditLineCB
    $frame marker $id delete callback text TextMarkerCB
    $frame marker $id delete callback color ColorMarkerCB
    $frame marker $id delete callback width LineWidthMarkerCB
    $frame marker $id delete callback property PropertyMarkerCB
    $frame marker $id delete callback font FontMarkerCB
    $frame marker $id delete callback delete DeleteLineDialog

    DeleteLineDialog $frame $id
}

proc DeleteLineDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,x2)
    unset marker($frame,$id,y2)
    unset marker($frame,$id,dist)
    unset marker($frame,$id,dcoord)
    unset marker($frame,$id,dformat)
    unset marker($frame,$id,dlabel)
    unset marker($frame,$id,p1arrow)
    unset marker($frame,$id,p2arrow)
}

proc EditLineDialog {frame id} {
    global marker

    $frame marker $id line point \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,x) $marker($frame,$id,y) \
	$marker($frame,$id,x2) $marker($frame,$id,y2)

    set marker($frame,$id,dist) [$frame get marker $id line distance \
		$marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
}

proc EditLineCB {frame id} {
    global marker

    set p [$frame get marker $id line point \
	       $marker($frame,$id,system) $marker($frame,$id,sky) \
	       $marker($frame,$id,skyformat)]

    set marker($frame,$id,x) [lindex $p 0]
    set marker($frame,$id,y) [lindex $p 1]
    set marker($frame,$id,x2) [lindex $p 2]
    set marker($frame,$id,y2) [lindex $p 3]

    set marker($frame,$id,dist) [$frame get marker $id line distance \
		$marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
}

proc CoordLineCB {frame id} {
    CoordMarkerCB $frame $id

    EditLineCB $frame $id
}

proc DistLineCB {frame id} {
    global marker
    set mb ".mb$id"

    AdjustDist $frame marker($frame,$id,dcoord)

    set marker($frame,$id,dlabel) $marker($frame,$id,dcoord)
    switch -- $marker($frame,$id,dcoord) {
	image -
	physical -
	amplifier -
	detector {}
	default {
	    if [$frame has wcs $marker($frame,$id,dcoord)] {
		if [$frame has wcs equatorial $marker($frame,$id,dcoord)] {
		    set marker($frame,$id,dlabel) $marker($frame,$id,dformat)
		} else {
		    set name [$frame get wcs name $marker($frame,$id,dcoord)]
		    if {$name != ""} {
			set marker($frame,$id,dlabel) $name
		    }
		}
	    }
	}
    }

    set marker($frame,$id,dist) [$frame get marker $id line distance \
		$marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
}

proc ArrowLineDialog {frame id} {
    global marker
    
    $frame marker $id line arrow \
	$marker($frame,$id,p1arrow) $marker($frame,$id,p2arrow)
}
