#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc InitPanner {} {
    global panner

    # other bindings
    BindEventsPanner

    bind $panner(name) <Tab> [list NextFrame]
    bind $panner(name) <Shift-Tab> [list PrevFrame]

    bind $panner(name) <Enter> [list focus $panner(name)]
    bind $panner(name) <Leave> [list focus {}]

    # freeze
    bind $panner(name) <f> {ToggleFreeze}
}

proc FreezePanner {} {
    UnBindEventsPanner
}

proc UnFreezePanner {} {
    BindEventsPanner
}

proc BindEventsPanner {} {
    global panner

    $panner(name) bind panner <Enter> [list EnterPanner %x %y]
    $panner(name) bind panner <Leave> [list LeavePanner]
    $panner(name) bind panner <Motion> [list MotionPanner %x %y]
    $panner(name) bind panner <Button-1> [list Button1Panner %x %y]
    $panner(name) bind panner <B1-Motion> [list Motion1Panner %x %y]
    $panner(name) bind panner <ButtonRelease-1> [list Release1Panner %x %y]
    $panner(name) bind panner <ButtonRelease-2> [list Release2Panner %x %y]

    $panner(name) bind panner <Up> [list ArrowKeyPanner 0 -1]
    $panner(name) bind panner <Down> [list ArrowKeyPanner 0 1]
    $panner(name) bind panner <Left> [list ArrowKeyPanner -1 0]
    $panner(name) bind panner <Right> [list ArrowKeyPanner 1 0]
}

proc UnBindEventsPanner {} {
    global panner

    $panner(name) bind panner <Enter> {}
    $panner(name) bind panner <Leave> {}
    $panner(name) bind panner <Motion> {}
    $panner(name) bind panner <Button-1> {}
    $panner(name) bind panner <B1-Motion> {}
    $panner(name) bind panner <ButtonRelease-1> {}
    $panner(name) bind panner <ButtonRelease-2> {}

    $panner(name) bind panner <Up> {}
    $panner(name) bind panner <Down> {}
    $panner(name) bind panner <Left> {}
    $panner(name) bind panner <Right> {}
}

proc EnterPanner {x y} {
    global panner
    global current

    global debug
    if {$debug(tcl,events)} {
	puts "EnterPanner"
    }

    focus $panner(name)
    $panner(name) focus panner

    if {$current(frame) != {}} {
	EnterInfoBox $current(frame) $x $y panner
	UpdatePixelTable $current(frame) $x $y panner
	UpdateGraph $current(frame) $x $y panner
    }
}

proc LeavePanner {} {
    global panner

    global debug
    if {$debug(tcl,events)} {
	puts "LeavePanner"
    }

    panner highlite off
    $panner(name) focus {}
    focus {}

    LeaveInfoBox
    ClearPixelTable
    ClearGraphData
}

proc MotionPanner {x y} {
    global current

    global debug
    if {$debug(tcl,events)} {
	puts "MotionPanner"
    }

    panner highlite $x $y
    if {$current(frame) != ""} {
	MotionInfoBox $current(frame) $x $y panner
	UpdatePixelTable $current(frame) $x $y panner
	UpdateGraph $current(frame) $x $y panner
    }
}

proc Button1Panner {x y} {
    global ds9

    global debug
    if {$debug(tcl,events)} {
	puts "Button1Panner"
    }

    panner pan begin $x $y
}

proc Motion1Panner {x y} {
    global ds9

    global debug
    if {$debug(tcl,events)} {
	puts "Motion1Panner"
    }

    panner pan motion $x $y
}

proc Release1Panner {x y} {
    global ds9
    global current

    global debug
    if {$debug(tcl,events)} {
	puts "Release1Panner"
    }

    if {$current(frame) != ""} {
	SetWatchCursor
	panner pan end $x $y
	$current(frame) pan bbox [panner get bbox]
	UpdateGraphXAxis
	UpdatePanZoomDialog
	UnsetWatchCursor
    }
}

proc Release2Panner {x y} {
    global ds9
    global current

    if {$current(frame) != ""} {
	SetWatchCursor
	panner pan to $x $y
	$current(frame) pan bbox [panner get bbox]
	UpdateGraphXAxis
	UpdatePanZoomDialog
	UnsetWatchCursor
    }
}

proc ArrowKeyPanner {x y} {
    panner warp $x $y
}

proc ChangeImageCompass {} {
    global panner
    
    panner image compass $panner(compass,image)
}

proc ChangeWCSCompass {} {
    global ds9
    global panner

    panner wcs compass $panner(compass,wcs)
    foreach f $ds9(frames) {
	$f panner wcs $panner(compass,wcs,system) $panner(compass,wcs,sky)
    }
}
