// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "outfile.h"

OutFitsFile::OutFitsFile(const char* fn)
{
  if (fd_ = fopen(fn, "wb"))
    valid_ = 1;
}

OutFitsFile::~OutFitsFile()
{
  if (fd_)
    fclose(fd_);
}

int OutFitsFile::write(char* d, int s)
{
  return fwrite(d, 1, s, fd_);
}

OutFitsFileGZ::OutFitsFileGZ(const char* fn)
{
  if (fd_ = gzopen(fn, "wb"))
    valid_ = 1;
}

OutFitsFileGZ::~OutFitsFileGZ()
{
  if (fd_)
    gzclose(fd_);
}

int OutFitsFileGZ::write(char* d, int s)
{
  return gzwrite(fd_, d, s);
}

