// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifdef HAVE_SYS_SHM_H
#include <sys/shm.h>
#include <sys/ipc.h>

#include "sshare.h"

FitsSShareID::FitsSShareID(int hdrid, int shmid, const char* filter)
{
  {
    // find size
    struct shmid_ds info;
    if (shmctl(hdrid, IPC_STAT, &info)) {
      cerr << "Fitsy++ Internal Error: shctl failed" << endl;
      return;
    }
    hmapsize_ = info.shm_segsz;

    // Attach the memory segment
    if ((long)(hmapdata_ = (char*)shmat(hdrid, 0, SHM_RDONLY)) == -1) {
      cerr << "Fitsy++ Internal Error: shmat failed" << endl;
      return;
    }
  }

  {
    parse(filter);

    // find size
    struct shmid_ds info;
    if (shmctl(shmid, IPC_STAT, &info)) {
      cerr << "Fitsy++ Internal Error: shctl failed" << endl;
      return;
    }
    mapsize_ = info.shm_segsz;

    // Attach the memory segment
    if ((long)(mapdata_ = (char*)shmat(shmid, 0, SHM_RDONLY)) == -1) {
      cerr << "Fitsy++ Internal Error: shmat failed" << endl;
      return;
    }
  }

  // so far so good
  valid_ = 1;
}

FitsSShareID::~FitsSShareID()
{
  shmdt(mapdata_);
}

FitsSShareKey::FitsSShareKey(int hdr, int key, const char* filter)
{
  {
    // get shmid
    int shmid;
    if ((shmid = shmget(hdr, 0, 0)) < 0) {
      cerr << "Fitsy++ Internal Error: shmget failed" << endl;
      return;
    }

    // find size
    struct shmid_ds info;
    if (shmctl(shmid, IPC_STAT, &info)) {
      cerr << "Fitsy++ Internal Error: shctl failed" << endl;
      return;
    }
    mapsize_ = info.shm_segsz;

    // Attach the memory segment
    if ((long)(mapdata_ = (char*)shmat(shmid, 0, SHM_RDONLY)) == -1) {
      cerr << "Fitsy++ Internal Error: shmat failed" << endl;
      return;
    }
  }

  {
    parse(filter);

    // get shmid
    int shmid;
    if ((shmid = shmget(key, 0, 0)) < 0) {
      cerr << "Fitsy++ Internal Error: shmget failed" << endl;
      return;
    }

    // find size
    struct shmid_ds info;
    if (shmctl(shmid, IPC_STAT, &info)) {
      cerr << "Fitsy++ Internal Error: shctl failed" << endl;
      return;
    }
    mapsize_ = info.shm_segsz;

    // Attach the memory segment
    if ((long)(mapdata_ = (char*)shmat(shmid, 0, SHM_RDONLY)) == -1) {
      cerr << "Fitsy++ Internal Error: shmat failed" << endl;
      return;
    }
  }

  // so far so good
  valid_ = 1;
}

FitsSShareKey::~FitsSShareKey()
{
  shmdt(mapdata_);
}
#else
#include "sshare.h"

FitsSShareID::FitsSShareID(int hdrid, int shmid, const char* filter)
{
  // shared memory not supported
  valid_ = 0;
}

FitsSShareID::~FitsSShareID() {}

FitsSShareKey::FitsSShareKey(int hdr, int key, const char* filter)
{
  // shared memory not supported
  valid_ = 0;
}

FitsSShareKey::~FitsSShareKey() {}
#endif
