// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "basebox.h"
#include "framebase.h"
#include "util.h"

BaseBox::BaseBox(const BaseBox& a) : BaseMarker(a)
{
  flip = a.flip;

  size = new Vector[a.annuli];
  for (int i=0; i<a.annuli; i++)
    size[i] = a.size[i];
}

BaseBox::BaseBox(FrameBase* p, const Vector& ctr, double a,
		 const char* clr, int w, const char* f, 
		 const char* t, unsigned short prop, const char* c,
		 const List<Tag>& tag)
  : BaseMarker(p, ctr, 4, clr, w, f, t, prop, c, tag)
{
  size = NULL;
  angle = a;

  if (!parent->isIIS())
    flip = FlipY();
}

BaseBox::~BaseBox()
{
  if (size)
    delete [] size;
}

void BaseBox::updateCoords(const Matrix& m)
{
  for (int i=0; i<annuli; i++)
    size[i] *= Scale(m);

  Marker::updateCoords(m);
}

int BaseBox::isIn(const Vector& v)
{
  // v is in canvas coords

  Vector s = size[annuli-1];
  if (properties & FIXED)
    s /= parent->getZoom();

  Vector p = v * 
    parent->canvasToRef * Translate(-center) * flip * Rotate(-angle);

  if (p[0]<-s[0]/2 || p[0]>s[0]/2 || p[1]<-s[1]/2 || p[1]>s[1]/2)
    return 0;
  else
    return 1;
}

// private

void BaseBox::calcPoints(double zoom)
{
  Matrix m;
  if (properties & FIXED)
    m = Scale(1/zoom) * Rotate(angle) * flip * Translate(center);
  else
    m = Rotate(angle) * flip * Translate(center);

  for (int i=0; i<annuli; i++) {
    vertices[i][0] = Vector(-size[i][0]/2.,-size[i][1]/2.) * m;
    vertices[i][1] = Vector( size[i][0]/2.,-size[i][1]/2.) * m;
    vertices[i][2] = Vector( size[i][0]/2., size[i][1]/2.) * m;
    vertices[i][3] = Vector(-size[i][0]/2., size[i][1]/2.) * m;
  }

  vertices[annuli][0] = vertices[annuli-1][0];
  vertices[annuli][1] = vertices[annuli-1][2];
}

