// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorscaletrue8_h__
#define __colorscaletrue8_h__

#include "colorscale.h"

class ColorScaleTrueColor8 : public virtual ColorScale {
public:
  ColorScaleTrueColor8(int, unsigned long, unsigned long, unsigned long);
  virtual ~ColorScaleTrueColor8();
};

class LinearScaleTrueColor8 :
public virtual ColorScale, 
public LinearScale, 
public ColorScaleTrueColor8 {
public:
  LinearScaleTrueColor8(int, unsigned short*, unsigned char*, int, 
			unsigned long, unsigned long, unsigned long);
};

class LogScaleTrueColor8 :
public virtual ColorScale, 
public LogScale, 
public ColorScaleTrueColor8 {
public:
  LogScaleTrueColor8(int, unsigned short*, unsigned char*, int,
		     unsigned long, unsigned long, unsigned long);
};

class SquaredScaleTrueColor8 :
public virtual ColorScale, 
public SquaredScale, 
public ColorScaleTrueColor8 {
public:
  SquaredScaleTrueColor8(int, unsigned short*, unsigned char*, int,
			 unsigned long, unsigned long, unsigned long);
};

class SqrtScaleTrueColor8 :
public virtual ColorScale, 
public SqrtScale, 
public ColorScaleTrueColor8 {
public:
  SqrtScaleTrueColor8(int, unsigned short*, unsigned char*, int,
		      unsigned long, unsigned long, unsigned long);
};

class IISScaleTrueColor8 :
public virtual ColorScale, 
public IISScale, 
public ColorScaleTrueColor8 {
public:
  IISScaleTrueColor8(unsigned short*, unsigned char*, int, 
		     unsigned long, unsigned long, unsigned long);
};

class HistEquScaleTrueColor8 :
public virtual ColorScale, 
public HistEquScale, 
public ColorScaleTrueColor8 {
public:
  HistEquScaleTrueColor8(int, unsigned short*, unsigned char*, int, 
			 double*, int,
			 unsigned long, unsigned long, unsigned long);
};

#endif
