/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse tngparse
#define yylex   tnglex
#define yyerror tngerror
#define yylval  tnglval
#define yychar  tngchar
#define yydebug tngdebug
#define yynerrs tngnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     INT = 258,
     REAL = 259,
     STRING = 260,
     DEGREE = 261,
     SEXSTR = 262,
     BACKGROUND_ = 263,
     BOX_ = 264,
     BLACK_ = 265,
     BLUE_ = 266,
     CIRCLE_ = 267,
     CYAN_ = 268,
     DATE_ = 269,
     DEBUG_ = 270,
     DEGREES_ = 271,
     ECLIPTIC_ = 272,
     ELLIPSE_ = 273,
     FILENAME_ = 274,
     FK4_ = 275,
     FK5_ = 276,
     FORMAT_ = 277,
     GALACTIC_ = 278,
     GREEN_ = 279,
     HMS_ = 280,
     ICRS_ = 281,
     LINE_ = 282,
     MAGENTA_ = 283,
     OFF_ = 284,
     ON_ = 285,
     PHYSICAL_ = 286,
     PIXELS_ = 287,
     POINT_ = 288,
     POLYGON_ = 289,
     RED_ = 290,
     SOURCE_ = 291,
     TEXT_ = 292,
     VERSION_ = 293,
     WHITE_ = 294,
     YELLOW_ = 295
   };
#endif
#define INT 258
#define REAL 259
#define STRING 260
#define DEGREE 261
#define SEXSTR 262
#define BACKGROUND_ 263
#define BOX_ 264
#define BLACK_ 265
#define BLUE_ 266
#define CIRCLE_ 267
#define CYAN_ 268
#define DATE_ 269
#define DEBUG_ 270
#define DEGREES_ 271
#define ECLIPTIC_ 272
#define ELLIPSE_ 273
#define FILENAME_ 274
#define FK4_ 275
#define FK5_ 276
#define FORMAT_ 277
#define GALACTIC_ 278
#define GREEN_ 279
#define HMS_ 280
#define ICRS_ 281
#define LINE_ 282
#define MAGENTA_ 283
#define OFF_ 284
#define ON_ 285
#define PHYSICAL_ 286
#define PIXELS_ 287
#define POINT_ 288
#define POLYGON_ 289
#define RED_ 290
#define SOURCE_ 291
#define TEXT_ 292
#define VERSION_ 293
#define WHITE_ 294
#define YELLOW_ 295




/* Copy the first part of user declarations.  */
#line 5 "tngparser.Y"

#define YYPARSE_PARAM fr
#define YYDEBUG 1

#define FR ((FrameBase*)fr)
#define FITSPTR (FR->findFits(1))

#define DISCARD_(x) {yyclearin; tngDiscard(x);}

#include <math.h>
#include <string.h>
#include <iostream.h>

#include "framebase.h"
#include "fitsimage.h"
#include "util.h"
#include "vector.h"
#include "list.h"
#include "basemarker.h"
#include "coord.h"

extern int tnglex(void);
extern void tngerror(const char*);
extern void tngDiscard(int);

int tngsign;
int tngsign2;

static CoordSystem globalSystem;
static SkyFrame globalSky;
static CoordSystem localSystem;
static SkyFrame localSky;

static unsigned short globalProps;
static unsigned short localProps;

static char globalColor[16];
static char localColor[16];

static char globalFont[32];

static char globalText[80];
static char localText[80];

static char localComment[80];

static List<Vertex> polylist;
static List<Tag> taglist;

static void setProps(unsigned short* props, unsigned short prop, int value);
static CoordSystem checkWCSSystem();
static SkyFrame checkWCSSky();


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 59 "tngparser.Y"
typedef union YYSTYPE {
  double real;
  int integer;
  char str[256];
  double vector[3];
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 225 "tngparser.C"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 237 "tngparser.C"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   128

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  50
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  33
/* YYNRULES -- Number of rules. */
#define YYNRULES  79
/* YYNRULES -- Number of states. */
#define YYNSTATES  142

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   295

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      41,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    48,     2,     2,     2,     2,
      44,    45,     2,    46,    43,    47,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    49,    42,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     6,    10,    13,    14,    17,    19,    23,
      25,    27,    29,    31,    33,    35,    37,    38,    40,    41,
      43,    44,    46,    47,    49,    51,    53,    55,    59,    61,
      65,    69,    73,    75,    77,    79,    81,    83,    84,    85,
      86,    88,    90,    98,   108,   118,   119,   126,   134,   135,
     144,   150,   154,   156,   158,   163,   164,   170,   171,   177,
     178,   182,   183,   186,   189,   192,   195,   198,   201,   204,
     207,   210,   213,   214,   218,   221,   224,   226,   231,   232
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      51,     0,    -1,    67,    52,    -1,    52,    53,    54,    -1,
      53,    54,    -1,    -1,    15,    56,    -1,    38,    -1,    68,
      69,    70,    -1,    75,    -1,    41,    -1,    42,    -1,     4,
      -1,     3,    -1,    30,    -1,    29,    -1,    -1,    43,    -1,
      -1,    44,    -1,    -1,    45,    -1,    -1,    61,    -1,    55,
      -1,     6,    -1,    55,    -1,    55,    57,    55,    -1,     7,
      -1,    64,    57,    64,    -1,    55,    57,    55,    -1,     6,
      57,     6,    -1,    20,    -1,    21,    -1,    23,    -1,    17,
      -1,    26,    -1,    -1,    -1,    -1,    46,    -1,    47,    -1,
      12,    58,    65,    57,    62,    59,    79,    -1,    18,    58,
      65,    57,    63,    57,    60,    59,    79,    -1,     9,    58,
      65,    57,    63,    57,    60,    59,    79,    -1,    -1,    34,
      71,    58,    73,    59,    79,    -1,    27,    58,    65,    57,
      65,    59,    79,    -1,    -1,    37,    58,    65,    57,     5,
      59,    72,    79,    -1,    33,    58,    65,    59,    79,    -1,
      73,    57,    74,    -1,    74,    -1,    65,    -1,    48,    22,
      49,    81,    -1,    -1,    48,    19,    49,    76,     5,    -1,
      -1,    48,    14,    49,    77,     5,    -1,    -1,    48,    78,
       5,    -1,    -1,    48,    39,    -1,    48,    10,    -1,    48,
      35,    -1,    48,    24,    -1,    48,    11,    -1,    48,    13,
      -1,    48,    28,    -1,    48,    40,    -1,    48,    36,    -1,
      48,     8,    -1,    -1,    48,    80,     5,    -1,    25,    82,
      -1,    16,    82,    -1,    32,    -1,    32,    44,    31,    45,
      -1,    -1,    44,    66,    45,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   120,   120,   123,   124,   127,   128,   129,   130,   131,
     134,   135,   138,   139,   142,   143,   146,   147,   150,   151,
     154,   155,   158,   159,   162,   163,   166,   169,   178,   181,
     195,   202,   212,   213,   214,   215,   216,   219,   233,   246,
     247,   248,   251,   256,   261,   266,   266,   270,   275,   275,
     280,   286,   287,   290,   293,   294,   294,   295,   295,   296,
     296,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   313,   318,   318,   321,   322,   323,   324,   328,   332
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "INT", "REAL", "STRING", "DEGREE", 
  "SEXSTR", "BACKGROUND_", "BOX_", "BLACK_", "BLUE_", "CIRCLE_", "CYAN_", 
  "DATE_", "DEBUG_", "DEGREES_", "ECLIPTIC_", "ELLIPSE_", "FILENAME_", 
  "FK4_", "FK5_", "FORMAT_", "GALACTIC_", "GREEN_", "HMS_", "ICRS_", 
  "LINE_", "MAGENTA_", "OFF_", "ON_", "PHYSICAL_", "PIXELS_", "POINT_", 
  "POLYGON_", "RED_", "SOURCE_", "TEXT_", "VERSION_", "WHITE_", "YELLOW_", 
  "'\\n'", "';'", "','", "'('", "')'", "'+'", "'-'", "'#'", "':'", 
  "$accept", "start", "commands", "command", "terminator", "numeric", 
  "debug", "sp", "bp", "ep", "optangle", "angle", "value", "vvalue", 
  "sexagesimal", "coord", "skyFrame", "initGlobal", "initLocal", 
  "include", "shape", "@1", "@2", "polyNodes", "polyNode", 
  "generalComment", "@3", "@4", "@5", "shapeComment", "@6", "tngFormat", 
  "tngWCS", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,    10,    59,    44,    40,    41,    43,    45,    35,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    50,    51,    52,    52,    53,    53,    53,    53,    53,
      54,    54,    55,    55,    56,    56,    57,    57,    58,    58,
      59,    59,    60,    60,    61,    61,    62,    63,    64,    65,
      65,    65,    66,    66,    66,    66,    66,    67,    68,    69,
      69,    69,    70,    70,    70,    71,    70,    70,    72,    70,
      70,    73,    73,    74,    75,    76,    75,    77,    75,    78,
      75,    79,    79,    79,    79,    79,    79,    79,    79,    79,
      79,    79,    80,    79,    81,    81,    81,    81,    82,    82
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     2,     3,     2,     0,     2,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     1,     1,     1,     3,     1,     3,
       3,     3,     1,     1,     1,     1,     1,     0,     0,     0,
       1,     1,     7,     9,     9,     0,     6,     7,     0,     8,
       5,     3,     1,     1,     4,     0,     5,     0,     5,     0,
       3,     0,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     0,     3,     2,     2,     1,     4,     0,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
      37,     0,    38,     1,     0,     7,    59,    38,     0,    39,
       9,    15,    14,     6,     0,     0,     0,     0,     0,    10,
      11,     4,    40,    41,     0,    57,    55,     0,    60,     3,
      18,    18,    18,    18,    18,    45,    18,     8,     0,     0,
      78,    78,    76,    54,    19,     0,     0,     0,     0,     0,
      18,     0,    58,    56,     0,    75,    74,     0,    13,    12,
      16,    28,    16,    16,    16,    16,    16,    16,    20,     0,
      16,    35,    32,    33,    34,    36,     0,     0,    17,     0,
       0,     0,     0,     0,     0,     0,    21,    61,    53,    16,
      52,     0,    79,    77,    31,    30,    29,    16,    16,    26,
      20,    16,    20,    72,    50,     0,    61,    20,     0,    22,
      61,    22,    61,    71,    63,    66,    67,    65,    68,    64,
      70,    62,    69,     0,    51,    46,    48,    27,    25,    24,
      20,    23,    42,    20,    47,    73,    61,    61,    61,    49,
      44,    43
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     7,     8,    21,    62,    13,    79,    45,    87,
     130,   131,   100,    98,    63,    88,    76,     2,     9,    24,
      37,    50,   136,    89,    90,    10,    39,    38,    17,   104,
     123,    43,    55
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -87
static const yysigned_char yypact[] =
{
     -87,    12,    -5,   -87,   -28,   -87,    56,     0,   -24,    -7,
     -87,   -87,   -87,   -87,   -30,   -27,    -3,    48,   -24,   -87,
     -87,   -87,   -87,   -87,    73,   -87,   -87,   -12,   -87,   -87,
      11,    11,    11,    11,    11,   -87,    11,   -87,    51,    55,
      27,    27,    28,   -87,   -87,   118,   118,   118,   118,   118,
      11,   118,   -87,   -87,    88,   -87,   -87,    42,   -87,   -87,
      36,   -87,    36,    36,    36,    36,    36,    36,    29,   118,
      36,   -87,   -87,   -87,   -87,   -87,    38,    39,   -87,    80,
      31,    83,    31,    31,    31,   118,   -87,    46,   -87,    75,
     -87,    97,   -87,   -87,   -87,   -87,   -87,    36,    36,   -87,
      29,    36,    29,    41,   -87,   118,    46,    29,    31,    26,
      46,    26,    46,   -87,   -87,   -87,   -87,   -87,   -87,   -87,
     -87,   -87,   -87,    98,   -87,   -87,   -87,   -87,   -87,   -87,
      29,   -87,   -87,    29,   -87,   -87,    46,    46,    46,   -87,
     -87,   -87
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -87,   -87,   -87,   105,    86,   -16,   -87,   -39,    65,   -86,
       2,   -87,   -87,    35,    45,   -40,   -87,   -87,   -87,   -87,
     -87,   -87,   -87,   -87,    22,   -87,   -87,   -87,   -87,   -49,
     -87,   -87,    87
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -21
static const short yytable[] =
{
      -2,    11,    12,   106,    40,    64,    65,    66,    67,    68,
       4,    70,     3,    41,   110,     4,   112,    19,    20,    25,
      42,   126,    26,    80,    81,    82,    83,    84,    85,    58,
      59,    91,   128,     5,    58,    59,    -5,    -5,     5,    22,
      23,    -5,    -5,     6,   137,   102,    27,   138,     6,   113,
     105,   114,   115,    28,   116,    44,    52,   125,   108,   109,
      53,   132,   111,   134,    95,   117,    97,    99,    97,   118,
      14,    54,    57,    77,    86,    15,   119,   120,    16,    78,
     121,   122,    30,    92,    93,    31,    94,   139,   140,   141,
      61,    32,   127,   129,   103,   129,    46,    47,    48,    49,
      33,    51,   107,   135,    29,    71,    34,    35,    72,    73,
      36,    74,    18,   133,    75,    69,   -20,   -20,    78,   101,
      86,    58,    59,   -20,    60,    61,    96,   124,    56
};

static const unsigned char yycheck[] =
{
       0,    29,    30,    89,    16,    45,    46,    47,    48,    49,
      15,    51,     0,    25,   100,    15,   102,    41,    42,    49,
      32,   107,    49,    62,    63,    64,    65,    66,    67,     3,
       4,    70,     6,    38,     3,     4,    41,    42,    38,    46,
      47,    41,    42,    48,   130,    85,    49,   133,    48,     8,
      89,    10,    11,     5,    13,    44,     5,   106,    97,    98,
       5,   110,   101,   112,    80,    24,    82,    83,    84,    28,
      14,    44,    44,    31,    45,    19,    35,    36,    22,    43,
      39,    40,     9,    45,    45,    12,     6,   136,   137,   138,
       7,    18,   108,   109,    48,   111,    31,    32,    33,    34,
      27,    36,     5,     5,    18,    17,    33,    34,    20,    21,
      37,    23,     7,   111,    26,    50,    41,    42,    43,    84,
      45,     3,     4,    48,     6,     7,    81,   105,    41
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    51,    67,     0,    15,    38,    48,    52,    53,    68,
      75,    29,    30,    56,    14,    19,    22,    78,    53,    41,
      42,    54,    46,    47,    69,    49,    49,    49,     5,    54,
       9,    12,    18,    27,    33,    34,    37,    70,    77,    76,
      16,    25,    32,    81,    44,    58,    58,    58,    58,    58,
      71,    58,     5,     5,    44,    82,    82,    44,     3,     4,
       6,     7,    55,    64,    65,    65,    65,    65,    65,    58,
      65,    17,    20,    21,    23,    26,    66,    31,    43,    57,
      57,    57,    57,    57,    57,    57,    45,    59,    65,    73,
      74,    57,    45,    45,     6,    55,    64,    55,    63,    55,
      62,    63,    65,    48,    79,    57,    59,     5,    57,    57,
      59,    57,    59,     8,    10,    11,    13,    24,    28,    35,
      36,    39,    40,    80,    74,    79,    59,    55,     6,    55,
      60,    61,    79,    60,    79,     5,    72,    59,    59,    79,
      79,    79
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 7:
#line 129 "tngparser.Y"
    {cerr << "SAOtng" << endl;;}
    break;

  case 12:
#line 138 "tngparser.Y"
    {yyval.real=yyvsp[0].real;;}
    break;

  case 13:
#line 139 "tngparser.Y"
    {yyval.real=yyvsp[0].integer;;}
    break;

  case 14:
#line 142 "tngparser.Y"
    {yydebug=1;;}
    break;

  case 15:
#line 143 "tngparser.Y"
    {yydebug=0;;}
    break;

  case 22:
#line 158 "tngparser.Y"
    {yyval.real = 0;;}
    break;

  case 23:
#line 159 "tngparser.Y"
    {yyval.real = yyvsp[0].real;;}
    break;

  case 24:
#line 162 "tngparser.Y"
    {yyval.real = degToRad(yyvsp[0].real);;}
    break;

  case 25:
#line 163 "tngparser.Y"
    {yyval.real = degToRad(yyvsp[0].real);;}
    break;

  case 26:
#line 166 "tngparser.Y"
    {yyval.real = FITSPTR->mapLenToRef(yyvsp[0].real,IMAGE);;}
    break;

  case 27:
#line 170 "tngparser.Y"
    {
	  Vector r = FITSPTR->mapLenToRef(Vector(yyvsp[-2].real,yyvsp[0].real), IMAGE);
	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 28:
#line 178 "tngparser.Y"
    {yyval.real = parseDMS(yyvsp[0].str);;}
    break;

  case 29:
#line 182 "tngparser.Y"
    {
	  Vector r;
	  CoordSystem sys = checkWCSSystem();
	  SkyFrame sky = checkWCSSky();
	  if (sky == GALACTIC || sky == ECLIPTIC) 
	    r = FITSPTR->mapToRef(Vector(yyvsp[-2].real,yyvsp[0].real), sys, sky);
	  else
	    r = FITSPTR->mapToRef(Vector(yyvsp[-2].real*360./24.,yyvsp[0].real), sys, sky);

	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 30:
#line 196 "tngparser.Y"
    {
	  Vector r = FITSPTR->mapToRef(Vector(yyvsp[-2].real,yyvsp[0].real), localSystem, localSky);
	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 31:
#line 203 "tngparser.Y"
    {
	  Vector r = FITSPTR->mapToRef(Vector(yyvsp[-2].real,yyvsp[0].real),
	    checkWCSSystem(), checkWCSSky());
	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 32:
#line 212 "tngparser.Y"
    {yyval.integer = FK4;;}
    break;

  case 33:
#line 213 "tngparser.Y"
    {yyval.integer = FK5;;}
    break;

  case 34:
#line 214 "tngparser.Y"
    {yyval.integer = GALACTIC;;}
    break;

  case 35:
#line 215 "tngparser.Y"
    {yyval.integer = ECLIPTIC;;}
    break;

  case 36:
#line 216 "tngparser.Y"
    {yyval.integer = ICRS;;}
    break;

  case 37:
#line 219 "tngparser.Y"
    {
	  // global properties
	  globalSystem = IMAGE;
	  globalSky = NATIVEWCS;
	  globalProps =
	    Marker::SELECT | Marker::EDIT | Marker::MOVE |
	    Marker::ROTATE | Marker::DELETE | Marker::HIGHLITE |
	    Marker::INCLUDE | Marker::SOURCE;
	  strcpy(globalColor,"green");
	  strcpy(globalFont,"helvetica 10 normal");
	  strcpy(globalText,"");
	;}
    break;

  case 38:
#line 233 "tngparser.Y"
    {
	  // global properties
	  localSystem = globalSystem;
	  localSky = localSky;
	  localProps = globalProps;
	  strcpy(localColor,globalColor);
	  strcpy(localText,globalText);
	  strcpy(localComment,"");

	  strcpy(globalText,"");
	;}
    break;

  case 39:
#line 246 "tngparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 1);;}
    break;

  case 40:
#line 247 "tngparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 1);;}
    break;

  case 41:
#line 248 "tngparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 0);;}
    break;

  case 42:
#line 252 "tngparser.Y"
    {FR->createCircleCmd(Vector(yyvsp[-4].vector),yyvsp[-2].real,
	    localColor,1,globalFont,localText,localProps,localComment,
	    taglist);;}
    break;

  case 43:
#line 257 "tngparser.Y"
    {FR->createEllipseCmd(Vector(yyvsp[-6].vector),Vector(yyvsp[-4].vector),yyvsp[-2].real,
	    localColor,1,globalFont,localText,localProps,localComment,
	    taglist);;}
    break;

  case 44:
#line 262 "tngparser.Y"
    {FR->createBoxCmd(Vector(yyvsp[-6].vector),Vector(yyvsp[-4].vector),yyvsp[-2].real,
	    localColor,1,globalFont,localText,localProps,localComment,
	    taglist);;}
    break;

  case 45:
#line 266 "tngparser.Y"
    {polylist.deleteAll();;}
    break;

  case 46:
#line 267 "tngparser.Y"
    {FR->createPolygonCmd(polylist,localColor,1,globalFont,
	      localText,localProps,localComment,taglist);;}
    break;

  case 47:
#line 271 "tngparser.Y"
    {FR->createLineCmd(Vector(yyvsp[-4].vector),Vector(yyvsp[-2].vector),
	    0,0,localColor,1,globalFont,localText,localProps,localComment,
	    taglist);;}
    break;

  case 48:
#line 275 "tngparser.Y"
    {strncpy(localText,yyvsp[-1].str,80);;}
    break;

  case 49:
#line 276 "tngparser.Y"
    {FR->createTextCmd(Vector(yyvsp[-5].vector),0,
	    localColor,1,globalFont,localText,localProps,localComment,
	    taglist);;}
    break;

  case 50:
#line 281 "tngparser.Y"
    {FR->createBoxCirclePointCmd(Vector(yyvsp[-2].vector),
	    localColor,1,globalFont,localText,localProps,localComment,
	    taglist);;}
    break;

  case 53:
#line 290 "tngparser.Y"
    {polylist.append(new Vertex(yyvsp[0].vector));;}
    break;

  case 55:
#line 294 "tngparser.Y"
    {DISCARD_(0);}
    break;

  case 57:
#line 295 "tngparser.Y"
    {DISCARD_(0);}
    break;

  case 59:
#line 296 "tngparser.Y"
    {DISCARD_(1);}
    break;

  case 60:
#line 296 "tngparser.Y"
    {strncpy(globalText,yyvsp[0].str,80);;}
    break;

  case 62:
#line 300 "tngparser.Y"
    {strcpy(localColor,"white");;}
    break;

  case 63:
#line 301 "tngparser.Y"
    {strcpy(localColor,"black");;}
    break;

  case 64:
#line 302 "tngparser.Y"
    {strcpy(localColor,"red");;}
    break;

  case 65:
#line 303 "tngparser.Y"
    {strcpy(localColor,"green");;}
    break;

  case 66:
#line 304 "tngparser.Y"
    {strcpy(localColor,"blue");;}
    break;

  case 67:
#line 305 "tngparser.Y"
    {strcpy(localColor,"cyan");;}
    break;

  case 68:
#line 306 "tngparser.Y"
    {strcpy(localColor,"magenta");;}
    break;

  case 69:
#line 307 "tngparser.Y"
    {strcpy(localColor,"yellow");;}
    break;

  case 70:
#line 309 "tngparser.Y"
    {
	  strcpy(localColor,"green");
	  setProps(&localProps,Marker::SOURCE,1);
	;}
    break;

  case 71:
#line 314 "tngparser.Y"
    {
	  strcpy(localColor,"red");
	  setProps(&localProps,Marker::SOURCE,0);
	;}
    break;

  case 72:
#line 318 "tngparser.Y"
    {DISCARD_(1);}
    break;

  case 73:
#line 318 "tngparser.Y"
    {strncpy(localComment,yyvsp[0].str,80);;}
    break;

  case 76:
#line 323 "tngparser.Y"
    {globalSystem = localSystem = IMAGE;;}
    break;

  case 77:
#line 324 "tngparser.Y"
    {globalSystem = localSystem = IMAGE;;}
    break;

  case 78:
#line 328 "tngparser.Y"
    {
	    globalSystem = localSystem = WCS;
	    globalSky = localSky = NATIVEWCS;
	  ;}
    break;

  case 79:
#line 333 "tngparser.Y"
    {
	    globalSystem = localSystem = WCS;
	    globalSky = localSky = (SkyFrame)yyvsp[-1].integer;
	  ;}
    break;


    }

/* Line 999 of yacc.c.  */
#line 1589 "tngparser.C"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 339 "tngparser.Y"


static void setProps(unsigned short* props, unsigned short prop, int value)
{
  if (value)
    *props |= prop;
  else
    *props &= ~prop;
}

static CoordSystem checkWCSSystem()
{
  switch (localSystem) {
  case IMAGE:
  case PHYSICAL:
    return WCS;
  default:
    return localSystem;
  }
}

static SkyFrame checkWCSSky()
{
  switch (localSystem) {
  case IMAGE:
  case PHYSICAL:
    return NATIVEWCS;
  default:
   return localSky;
  }
}

