#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc BoxAnnulusDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # base
    MarkerBaseAnnulusRectDialog $frame $id 275 150 size Width Height
}

# actions

proc BoxAnnulusClose {frame id} {
    MarkerBaseAnnulusRectClose $frame $id
}

proc BoxAnnulusApply {frame id} {
    MarkerBaseAnnulusRectApply $frame $id
}

proc BoxAnnulusGenerate {frame id} {
    MarkerBaseAnnulusGenerateBox $frame $id
}

# callbacks

proc BoxAnnulusCoordCB {frame id} {
    MarkerBaseAnnulusRectCoordCB $frame $id
}

proc BoxAnnulusEditCB {frame id} {
    MarkerBaseAnnulusRectEditCB $frame $id
}

proc BoxAnnulusDistCB {frame id} {
    MarkerBaseAnnulusRectDistCB $frame $id
}

proc BoxAnnulusDefaultDialog {} {
    MarkerBaseAnnulusRectDefaultDialog boxannulus Size Width Height
}
