// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __composite_h__
#define __composite_h__

#include "marker.h"
#include "list.h"

class Composite : public Marker {
 private:
  List<Marker> members;

protected:
  virtual void render(Drawable, const Matrix&, RenderMode);

public:
  Composite(const Composite&);
  Composite(FrameBase* p, const Vector& ctr, 
	    double ang,
	    const char* clr, int wth, 
	    const char* fnt, const char* txt,
	    unsigned short prop, const char* cmt,
	    const List<Tag>& tg, const List<CallBack>& cb);

  Marker* dup() {return new Composite(*this);}

  void updateBBox();
  void updateCoords(const Matrix&);

  void draw(Drawable);
  void drawXOR();
  void drawMagnifier(const Matrix&);

  void ps(int);
  int isIn(const Vector& v);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, int, int);
  void listCiao(ostream&, CoordSystem, int, int);
  void listSAOtng(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listSAOimage(ostream&, int);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, int);
  void listXY(ostream&, CoordSystem, SkyFrame, SkyFormat, int);

  void append(Marker*);
  Marker* extract();
};

#endif
