#!/bin/sh
# ./debian/repack
# Repackage the DS9 source files as a DFSG tarball, with unnecessary
# files removed. 

ver=$2
orig_tar=$3
tardir=$(dirname $orig_tar)
wd=$(mktemp -d)
echo $ver $orig_tar $tardir $wd

tar xf $orig_tar -C $wd 
srcdir=$wd/*

for subdir in funtools\* sla tcl8.\* tcllib-\* tk8.\* tkimg\* signal_ext\* \
              tktable\* tkcon-\* tclxml-\* wcssubs-\* xpa-\* \
              zip-\* zlib-\* compilers ast-\* zvfs ; do
    rm -rf $srcdir/$subdir
done

find $srcdir/ -name config.status |xargs rm -f
find $srcdir/ -name conf.h |xargs rm -f

dfsg_tar=$tardir/saods9_$ver+dfsg.orig.tar.gz
tar czf $dfsg_tar -C $wd .
rm -rf $wd

exec uupdate --no-symlink --upstream-version $ver+dfsg $dfsg_tar
