// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fitshist_h__
#define __fitshist_h__

#include "vector.h"
#include "file.h"

class FitsHist : public FitsFile {
 public:
  enum Function {SUM, AVERAGE};

 private:
  int width;
  int height;
  int depth;
  off_t size;

  FitsColumn* xcol;
  FitsColumn* ycol;
  FitsColumn* zcol;

  void* fitsy;
  void* filter;

  int initHeader(FitsFile*);
  void initLTMV(Matrix&);
  void initWCS(FitsFile*, Matrix&, Vector);
  void mapWCSMatrix(FitsHead*, char* w, const char* out, const char* in, 
		    Vector);
  void mapWCSReal(FitsHead* head, const char* out, const char* in);
  void mapWCSReal(FitsHead* head, char* w, const char* out, const char* in);
  void mapWCSReal(FitsHead*, char* w, 
		  const char* out, const char* prim, const char* alt, 
		  Matrix);
  void mapWCSString(FitsHead*, char* w, const char* out, const char* prim);
  void mapWCSString(FitsHead*, char* w, 
		    const char* out, const char* prim, const char* alt);
  void mapWCSVector(FitsHead*, char* w, const char* out, const char* in);
  void initFilter(FitsFile*);
  void deleteFilter();
  void bin(FitsFile*, Matrix&, Function, Vector);
  void swap();

 public:
  FitsHist(FitsFile* src, int width, int height, int depth, 
	   Matrix& m, Function func, Vector block);
  ~FitsHist();
};

class FitsHistNext : public FitsFile {
public:
  FitsHistNext(FitsFile* prev);
};

#endif
