// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __baseellipse_h__
#define __baseellipse_h__

#include "basemarker.h"

class BaseEllipse : public BaseMarker {
 private:
  double xyz(Vector rr, double ang);
  void XDrawCurve(Drawable, RenderMode, Vector&, Vector&, Vector&, Vector&);

  void renderXCircle(Drawable, Coord::InternalSystem, double, RenderMode);
  void renderXEllipse(Drawable, Coord::InternalSystem, double, RenderMode);
  void renderXEllipseCurve(Drawable, Coord::InternalSystem, RenderMode);
  void renderXEllipsePrep(Drawable, Coord::InternalSystem, RenderMode,
			  double, double, double, double, Vector&);
  void renderXEllipseArc(Drawable, Coord::InternalSystem, RenderMode, 
			 double, double, Vector&);
  void renderXInclude(Drawable, Coord::InternalSystem, RenderMode);

  void renderPSCircle(int);
  void renderPSEllipseCurve(int);
  void renderPSEllipsePrep(double, double, double, double, Vector&);
  void renderPSEllipseArc(double, double, Vector&);
  void renderPSInclude(int);

#ifdef _MACOSX
  void renderMACOSXCircle();
  void renderMACOSXEllipseCurve();
  void renderMACOSXEllipsePrep(double, double, double, double, Vector&);
  void renderMACOSXEllipseArc(double, double, Vector&);
  void renderMACOSXInclude();
#endif

#ifdef _WIN32
  void renderWIN32Circle();
  void renderWIN32EllipseCurve();
  void renderWIN32EllipsePrep(double, double, double, double, Vector&);
  void renderWIN32EllipseArc(double, double, Vector&);
  void renderWIN32Include();
#endif

 protected:
  void renderX(Drawable, Coord::InternalSystem, RenderMode);
  void renderPS(int);
#ifdef _MACOSX
  void renderMACOSX();
#endif
#ifdef _WIN32
  void renderWIN32();
#endif

  virtual void updateHandles();
  Vector intersect(Vector, double);

 public:
  BaseEllipse(const BaseEllipse&);
  BaseEllipse(Base* p, const Vector& ctr, 
	      double a,
	      const char* clr, int* dsh, 
	      int w, const char* f, const char* t, 
	      unsigned short prop, const char* c, 
	      const List<Tag>& tag, const List<CallBack>& cb);
  virtual ~BaseEllipse();

  virtual Marker* dup() =0;

  int isIn(const Vector& vv) {return isIn(vv, Coord::CANVAS);}
  int isIn(const Vector&, Coord::InternalSystem);
};

#endif


