// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __grid25d_h__
#define __grid25d_h__

#include <tk.h>

#include "grid.h"
#include "grid25dbase.h"
#include "coord.h"

class Grid25d : public Grid, public Grid25dBase {
 private:
  void* matrixMap(Matrix&, const char*);
  int doit(RenderMode);

 public:
  Grid25d(Widget*, Coord::CoordSystem, Coord::SkyFrame, Coord::SkyFormat, GridType, const char*);

  const char* option() {return Grid25dBase::option();}
  void render() {doit(X11);}
  void ps(int mode) {mode_=mode; doit(PS);}
#ifdef _MACOSX
  void macosx() {doit(MACOSX);}
#endif
#ifdef _WIN32
  void win32() {doit(GWIN32);}
#endif
};

#endif
