#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc OpenPhoto {} {
    global photofbox
    global current

    set fn [OpenFileDialog photofbox]
    if {$fn == {}} {
	return
    }

    StartLoad
    LoadPhoto $fn
    FinishLoad
}

proc OpenSlicePhoto {} {
    set fn [OpenFileDialog photofbox]
    if {$fn == {}} {
	return
    }

    StartLoad
    LoadSlicePhoto $fn
    FinishLoad
}

# Support

proc LoadPhoto {fn} {
    global loadParam

    if {[catch {image create photo -file $fn} ph]} {
	Error [msgcat::mc {An error has occurred while reading image.}]
	return
    }

    set loadParam(load,type) photo
    set loadParam(load,layer) {}
    set loadParam(file,type) photo
    set loadParam(file,mode) {}
    set loadParam(file,name) $fn
    set loadParam(var,name) $ph
    ProcessLoad

    image delete $ph
}

proc LoadSlicePhoto {fn} {
    global loadParam

    if {[catch {image create photo -file $fn} ph]} {
	Error [msgcat::mc {An error has occurred while reading image.}]
	return
    }

    set loadParam(load,type) photo
    set loadParam(load,layer) {}
    set loadParam(file,type) photo
    set loadParam(file,mode) {slice}
    set loadParam(file,name) $fn
    set loadParam(var,name) $ph
    ProcessLoad

    image delete $ph
}

proc ProcessPhotoCmd {varname iname} {
}

proc ProcessSendPhotoCmd {proc id param sock fn} {
}
