#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

# do this after the language has been defined and the prefs sourced
proc InitDialogBox {} {
    global ds9
    global pds9
    global env

    switch $ds9(wm) {
	x11 {}
	win32 {set ds9(dialog,dir) [GetEnvHome]}
	aqua {
	    switch -- $pds9(dialog) {
		native {}
		motif -
		windows {
		    # try to determine if invoked from 
		    # command line or double click
		    if {![info exists env(TERM)]} {
			set ds9(dialog,dir) [GetEnvHome]
		    }
		}
	    }
	}
    }

    global fitsfbox
    set fitsfbox(file) {}
    set fitsfbox(types) [list \
			     [list {FITS} {*.fits}] \
			     [list {FITS} {*.FITS}] \
			     [list {FITS} {*.fit}] \
			     [list {FITS} {*.FIT}] \
			     [list {FITS} {*.fts}] \
			     [list {FITS} {*.FTS}] \
			     [list {FITS} {*.ds}] \
			     [list {FITS} {*.DS}] \
			     [list {FITS} {*.fits.gz}] \
			     [list {FITS} {*.fits.bz2}] \
			     [list {FITS} {*.fits.Z}] \
			     [list {FITS} {*.fits.z}] \
			     [list {FITS} {*.fitz}] \
			     [list {FITS} {*.FITZ}] \
			     [list {FITS} {*.ftz}] \
			     [list {FITS} {*.FTZ}] \
			     [list {FITS} {*.fz}] \
			     [list {FITS} {*.FZ}] \
			     ]

    global savefitsfbox
    set savefitsfbox(file) {ds9.fits}
    set savefitsfbox(types) [list \
				 [list {FITS} {*.fits}] \
				 [list {FITS} {*.fit}] \
				 [list {FITS} {*.fts}] \
				 [list {FITS} {*.fits.gz}] \
				 [list {FITS} {*.fits.bz2}] \
				 [list {FITS} {*.fits.Z}] \
				 [list {FITS} {*.fits.z}] \
				]

    global fitsvarfbox
    set fitsvarfbox(file) {}
    set fitsvarfbox(types) [list \
				]

    global arrayfbox
    set arrayfbox(file) {}
    set arrayfbox(types) [list \
			      [list {ARR} {*.arr}] \
			  ]

    global pixelfbox
    set pixelfbox(file) {ds9.pix}
    set pixelfbox(types) [list \
			      [list {PIX} {*.pix}] \
			      ]

    global markerfbox
    set markerfbox(file) {ds9.reg}
    set markerfbox(types) [list \
			       [list {REG} {*.reg}] \
			       [list {FITS} {*.fits}] \
			       [list {XML} {*.xml}] \
			      ]

    global templatefbox
    set templatefbox(file) {ds9.tpl}
    set templatefbox(types) \
	[list [list {TPL} {*.tpl}] [list [::msgcat::mc {All}] {*}] ]

    global colorbarfbox
    set colorbarfbox(file) {}
    set colorbarfbox(types) [list \
				 [list [::msgcat::mc {Colormap}] {*.sao}] \
				 [list [::msgcat::mc {Colormap}]  {*.lut}] \
				]

    global contrastbiasfbox
    set contrastbiasfbox(file) {ds9.cb}
    set contrastbiasfbox(types) [list \
				     [list {CB} {*.cb}] \
				     ]

    global colortagfbox
    set colortagfbox(file) {ds9.tag}
    set colortagfbox(types) [list \
				 [list {Colortag} {*.tag}] \
				]

    global pssavfbox
    set pssavfbox(file) {ds9.ps}
    set pssavfbox(types) [list \
			      [list {PS} {*.ps}] \
			      ]

    global apsavfbox
    set apsavfbox(file) {ds9.ps}
    set apsavfbox(types) [list \
			      [list {PS} {*.ps}] \
			      ]

    global prsavfbox
    set prsavfbox(file) {ds9.txt}
    set prsavfbox(types) [list \
			      [list {TXT} {*.txt}] \
			      ]

    global contourfbox
    set contourfbox(file) {ds9.con}
    set contourfbox(types) [list \
				[list {CON} {*.con}] \
				]

    global contourlevfbox
    set contourlevfbox(file) {ds9.lev}
    set contourlevfbox(types) [list \
				   [list {LEV} {*.lev}] \
				   ]

    global gridfbox
    set gridfbox(file) {ds9.grd}
    set gridfbox(types) [list \
			     [list {GRD} {*.grd}] \
			    ]

    global catfbox
    set catfbox(file) {ds9.cat}
    set catfbox(types) [list \
			    [list [::msgcat::mc {Catalog}] {*.cat}] \
			    [list [::msgcat::mc {Catalog}] {*.rdb}] \
			   ]

    global cattsvfbox
    set cattsvfbox(file) {ds9.tsv}
    set cattsvfbox(types) [list \
			       [list [::msgcat::mc {Catalog}] {*.tsv}] \
			       [list [::msgcat::mc {Catalog}] {*.csv}] \
			      ]

    global catvotfbox
    set catvotfbox(file) {ds9.xml}
    set catvotfbox(types) [list \
			       [list [::msgcat::mc {Catalog}] {*.xml}] \
			       [list [::msgcat::mc {Catalog}] {*.vot}] \
			       [list [::msgcat::mc {Catalog}] {*.votable}] \
			      ]

    global catfltfbox
    set catfltfbox(file) {ds9.flt}
    set catfltfbox(types) [list \
			       [list {FLT} {*.flt}] \
			       ]

    global catsymfbox
    set catsymfbox(file) {ds9.sym}
    set catsymfbox(types) [list \
			       [list {SYM} {*.sym}] \
			       ]

    global catcdssrchfbox
    set catcdssrchfbox(file) {ds9.cds}
    set catcdssrchfbox(types) [list \
				   [list {CDS} {*.cds}] \
				   ]

    global analysisfbox
    set analysisfbox(file) {ds9.ans}
    set analysisfbox(types) [list \
				 [list [::msgcat::mc {Analysis}] {*.ans}] \
				 [list [::msgcat::mc {Analysis}] {*.ds9}] \
				]

    global analysisparamfbox
    set analysisparamfbox(file) {}
    set analysisparamfbox(types) [list \
				]

    global apdatafbox
    set apdatafbox(file) {ds9.dat}
    set apdatafbox(types) [list \
			       [list {DAT} {*.dat}] \
			       ]

    global apconfigfbox
    set apconfigfbox(file) {ds9.plt}
    set apconfigfbox(types) [list \
				 [list {PLT} {*.plt}] \
				 ]

    global textfbox
    set textfbox(file) {ds9.txt}
    set textfbox(types) [list \
			     [list {TXT} {*.txt}] \
			     ]

    global tclfbox
    set tclfbox(file) {}
    set tclfbox(types) [list \
			    [list {TCL} {*.tcl}] \
			    ]

    global hvhtmlfbox
    set hvhtmlfbox(file) {}
    set  hvhtmlfbox(types) [list \
				[list {HTML} {*.html}] \
				[list {HTML} {*.htm}] \
			       ]

    global wcsfbox
    set wcsfbox(file) {ds9.wcs}
    set wcsfbox(types) [list \
			    [list {WCS} {*.wcs}] \
			    ]

    global backupfbox
    set backupfbox(file) {ds9.bck}
    set backupfbox(types) [list \
			       [list {BCK} {*.bck}] \
			      ]

    global photofbox
    set photofbox(file) {}
    set photofbox(types) [list \
			      [list {GIF} {*.gif}] \
			      [list {JPEG} {*.jpeg}] \
			      [list {JPEG} {*.jpg}] \
			      [list {TIFF} {*.tiff}] \
			      [list {TIFF} {*.tif}] \
			      [list {PNG} {*.png}] \
			      [list {PPM} {*.ppm}] \
			     ]

    global exportfbox
    set exportfbox(file) {ds9}
    set exportfbox(types) [list \
				  ]

    global saveimagefbox
    set saveimagefbox(file) {ds9}
    set saveimagefbox(types) [list \
				  ]

    global moviefbox
    set moviefbox(file) {ds9.mpeg}
    set moviefbox(types) [list \
				 [list {MPEG} {*.mpeg}] \
				 [list {MPEG} {*.mpg}] \
				]
}

proc ExtToFormat {fn} {
    switch -- [file extension $fn] {
	.fits -
	.fit -
	.fts -
	.fitz -
	.ftz -
	.fz -
	.gif -
	.giff {return gif}
	.jpg -
	.jpeg {return jpeg}
	.tif -
	.tiff {return tiff}
	.png {return png}
	.ppm {return ppm}
	.mpg -
	.mpeg {return mpeg}
    }
}

proc FormatToFBox {format} {
    switch $format {
	fits {
	    return \
		[list \
		     [list {FITS} {*.fits}] \
		     [list {FITS} {*.fit}] \
		     [list {FITS} {*.fts}] \
		     [list {FITS} {*.fits.gz}] \
		     [list {FITS} {*.fits.bz2}] \
		     [list {FITS} {*.fits.Z}] \
		     [list {FITS} {*.fits.z}] \
		     [list {FITS} {*.fitz}] \
		     [list {FITS} {*.ftz}] \
		     [list {FITS} {*.fz}] \
		     [list [::msgcat::mc {All}] {*}] \
		    ]
	}
	gif {
	    return \
		[list \
		     [list {GIF} {*.gif}] \
		     [list [::msgcat::mc {All}] {*}] \
		    ]
	}
	jpeg {
	    return \
		[list \
		     [list {JPEG} {*.jpeg}] \
		     [list {JPEG} {*.jpg}] \
		     [list [::msgcat::mc {All}] {*}] \
		    ]
	}
	tiff {
	    return \
		[list \
		     [list {TIFF} {*.tiff}] \
		     [list {TIFF} {*.tif}] \
		     [list [::msgcat::mc {All}] {*}] \
		    ]
	}
	png {
	    return \
		[list \
		     [list {PNG} {*.png}] \
		     [list [::msgcat::mc {All}] {*}] \
		    ]
	}
	ppm	{
	    return \
		[list \
		     [list {PPM} {*.ppm}] \
		     [list [::msgcat::mc {All}] {*}] \
		    ]
	}
	mpeg {
	    return \
		[list \
		     [list {MPEG} {*.mpeg}] \
		     [list {MPEG} {*.mpg}] \
		     
		 ]
	}
    }
}

# used by backup
proc OpenFileDialog {varname} {
    return [FileDialog $varname tk_getOpenFile]
}

proc SaveFileDialog {varname} {
    return [FileDialog $varname tk_getSaveFile]
}

proc FileDialog {varname which} {
    global pds9

    switch -- $pds9(dialog) {
	motif {return [FileDialogMotif $varname $which]}
	windows {return [FileDialogWindows $varname $which]}
	native {return [FileDialogNative $varname $which]}
    }
}

proc FileDialogMotif {varname which} {
    upvar #0 $varname var
    global ds9
    global pds9

    switch -- $which {
	tk_getOpenFile {set type open}
	tk_getSaveFile {set type save}
    }


    if {$pds9(dialog,all)} {
	set types [linsert $var(types) 0 [list [::msgcat::mc {All}] {*}]]
    } else {
	set types [linsert $var(types) end [list [::msgcat::mc {All}] {*}]]
    }

    set result [::tk::MotifFDialog $type \
		    -filetypes $types \
		    -initialdir $ds9(dialog,dir) \
		    -initialfile $var(file) \
		    -parent $ds9(top)]

    if {$result != {}} {
	set var(file) [file tail $result]
	set ds9(dialog,dir) [file dirname $result]
    }

    return $result
}

proc FileDialogWindows {varname which} {
    upvar #0 $varname var
    global ds9
    global pds9

    switch -- $which {
	tk_getOpenFile {set type open}
	tk_getSaveFile {set type save}
    }

    if {$pds9(dialog,all)} {
	set types [linsert $var(types) 0 [list [::msgcat::mc {All}] {*}]]
    } else {
	set types [linsert $var(types) end [list [::msgcat::mc {All}] {*}]]
    }

    set result [::tk::dialog::file:: $type \
		    -filetypes $types \
		    -initialdir $ds9(dialog,dir) \
		    -initialfile $var(file) \
		    -parent $ds9(top)]

    if {$result != {}} {
	set var(file) [file tail $result]
	set ds9(dialog,dir) [file dirname $result]
    }

    return $result
}

proc FileDialogNative {varname which} {
    upvar #0 $varname var
    global ds9
    global pds9

    if {$pds9(dialog,all)} {
	set types [linsert $var(types) 0 [list [::msgcat::mc {All}] {*}]]
    } else {
	set types [linsert $var(types) end [list [::msgcat::mc {All}] {*}]]
    }

    if [catch {$which \
		   -filetypes $types \
		   -initialdir $ds9(dialog,dir) \
		   -initialfile $var(file) \
		   -parent $ds9(top)} result] {

	# must have a bad file name, just clear and try again
	set var(file) {}
	set ds9(dialog,dir) {}
	if [catch {$which \
		       -filetypes $types \
		       -parent $ds9(top)} result] {

	    #ok, something is really wrong
	    catch {$which -parent $ds9(top)} result
	}
    }

    if {$result != {}} {
	set var(file) [file tail $result]
	set ds9(dialog,dir) [file dirname $result]
    }

    return $result
}


proc FileLast {varname fn} {
    upvar #0 $varname var

    set var(file) [file tail $fn]
}

proc FileLastFull {varname fn} {
    upvar #0 $varname var
    global ds9

    set var(file) [file tail $fn]
    set ds9(dialog,dir) [file dirname $fn]
}
