// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fitshpx_h__
#define __fitshpx_h__

#include "vector.h"
#include "file.h"

class FitsHPX : public FitsFile {
 public:
  enum Order {RING, NESTED};
  enum CoordSys {UNKNOWN, EQU, GAL, ECL};
  enum Layout {EQUATOR=0, NORTH=1, SOUTH=2};

 private:
  Order order_;
  CoordSys coord_;
  Layout layout_;
  int quad_;

  FitsBinColumn* col_;

  long nside_;
  long nfacet_;

  void build(FitsFile*);
  int initHeader(FitsFile*);
  void swap();
  void NESTidx(int facet, int rotn, int jmap, long *healidx);
  void RINGidx(int facet, int rotn, int jmap, long *healidx);

 protected:
  size_t pSize_;

 public:
  FitsHPX(FitsFile*, Order, CoordSys, Layout, int, int);
  ~FitsHPX();
};

#endif
