
#ifdef FULLSCREEN

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <SDL/SDL.h>
#include <X11/Xlib.h>

#include "aquarium.h"
#include "defines.h"
#include "vroot.h"



int screen_width;
int screen_height;
int depth=24;


SDL_Surface *screen=NULL;
SDL_Surface *screen_image, *background;
SDL_Rect *fish_dest, *fish_src, *clean_dest;

int curr_dest, clean_count, no_sdl_quit;

char *sdl_command=NULL;


/* This is not nice!! */
SDL_Surface *thisfish[MAX_FISHES];

void turn_fishes()
{
  int i,j,k,ypos;


  for(i=0;i<NUMOFFISHTYPES;i++){
    if(fish_buffer[i].image!=NULL){
      fish_buffer[i].rev=g_malloc(fish_buffer[i].width*fish_buffer[i].height*4*fish_animation[i].pics);
    
      for(j=0;j<(fish_buffer[i].height*fish_animation[i].pics);j++){
	ypos=j*fish_buffer[i].width*4;
	for(k=0;k<fish_buffer[i].width;k++){
	  fish_buffer[i].rev[ypos+(fish_buffer[i].width-k-1)*4]  =fish_buffer[i].image[ypos+k*4];
	  fish_buffer[i].rev[ypos+(fish_buffer[i].width-k-1)*4+1]=fish_buffer[i].image[ypos+k*4+1];
	  fish_buffer[i].rev[ypos+(fish_buffer[i].width-k-1)*4+2]=fish_buffer[i].image[ypos+k*4+2];
	  fish_buffer[i].rev[ypos+(fish_buffer[i].width-k-1)*4+3]=fish_buffer[i].image[ypos+k*4+3];
	}
      }
    }
  }


  if(blowup_data.image!=NULL){

    blowup_data.rev=g_malloc(blowup_data.width*blowup_data.height*4*2);
   
      for(j=0;j<(blowup_data.height*2);j++){
	ypos=j*blowup_data.width*4;
	for(k=0;k<blowup_data.width;k++){
	  blowup_data.rev[ypos+(blowup_data.width-k-1)*4]  =blowup_data.image[ypos+k*4];
	  blowup_data.rev[ypos+(blowup_data.width-k-1)*4+1]=blowup_data.image[ypos+k*4+1];
	  blowup_data.rev[ypos+(blowup_data.width-k-1)*4+2]=blowup_data.image[ypos+k*4+2];
	  blowup_data.rev[ypos+(blowup_data.width-k-1)*4+3]=blowup_data.image[ypos+k*4+3];
	}
      }
  }
  if(prey_hunter_data.image!=NULL){

    prey_hunter_data.rev=g_malloc(prey_hunter_data.width*prey_hunter_data.height*4*7);

      for(j=0;j<(prey_hunter_data.height*7);j++){
	ypos=j*prey_hunter_data.width*4;
	for(k=0;k<prey_hunter_data.width;k++){
	  prey_hunter_data.rev[ypos+(prey_hunter_data.width-k-1)*4]  =prey_hunter_data.image[ypos+k*4];
	  prey_hunter_data.rev[ypos+(prey_hunter_data.width-k-1)*4+1]=prey_hunter_data.image[ypos+k*4+1];
	  prey_hunter_data.rev[ypos+(prey_hunter_data.width-k-1)*4+2]=prey_hunter_data.image[ypos+k*4+2];
	  prey_hunter_data.rev[ypos+(prey_hunter_data.width-k-1)*4+3]=prey_hunter_data.image[ypos+k*4+3];
	}
      }
  }


    

}


void fullscreen_draw_fish(int x, int y, int idx, int w, int h, unsigned char *pic)
{

  fish_dest[curr_dest].x=x;
  fish_dest[curr_dest].y=y;
  fish_dest[curr_dest].w=w;
  fish_dest[curr_dest].h=h;

  fish_src[curr_dest].x=0;
  fish_src[curr_dest].y=h*idx;
  fish_src[curr_dest].w=w;
  fish_src[curr_dest].h=h;


  thisfish[curr_dest]=SDL_CreateRGBSurfaceFrom(pic,w,h*(idx+1),32,w*4,0x000000ff, 0x0000ff00, 0x00ff0000, 0xff000000);

  curr_dest++;

  if(curr_dest>MAX_FISHES){
    printf("Waring!!! Too many fishes - Recompile and increase the #define MAX_FISHES!!\n"); 
    exit(-1);
  }

}




void fullscreen_clean(int x,int y,int w,int h)
{

  clean_dest[clean_count].x=x-5;
  clean_dest[clean_count].y=y-5;
  clean_dest[clean_count].w=w+10;
  clean_dest[clean_count].h=h+10;


  SDL_BlitSurface(background,&clean_dest[clean_count],screen,&clean_dest[clean_count]);

  clean_count++;
  if(clean_count>MAX_FISHES){
    printf("Waring!!! Too many fishes - Recompile and increase the #define MAX_FISHES!!\n"); 
    exit(-1);
  }

}

void fullscreen_quit()
{

  /* Resetting the term signal to the orignal so we can quit nicely.*/
  signal(SIGTERM, SIG_DFL);

  if(no_sdl_quit){
    /* Calling exit() will make a call to SDL_quit, so SIGTERM is nice */
    kill(getpid(),SIGTERM);
  }
  else{
    atexit(SDL_Quit); 
    exit(0);
  }
  
}


void fullscreen_main(void)
{
  SDL_Rect dest;
  SDL_Event event;
  AquariumData *a;


  clock_t totaltime1, totaltime2;
  clock_t cali1, cali2;


  int num_events=0;
  int main_loop=0;
  int totalframes=0, frames=0;
  int i;
  int delay=0;

  a=get_ad();


  if ( SDL_Init(SDL_INIT_VIDEO) < 0 ){
    printf("Can't init SDL: %s\n",SDL_GetError());
    exit(1);
  }
  /* Call SDL_Quit on exit - Important */
  atexit(SDL_Quit);

  /* So things are resorted to normal if sherman's get terminated - Like by xscreensaver*/
  signal(SIGTERM,fullscreen_quit); 



  /* I don't pass any other flags than fullscreen, because then it will
     hopefully work on nearly every graphic card. */

  if(xscreensaver==0){
    if(!SDL_VideoModeOK(screen_width,screen_height,depth, SDL_FULLSCREEN)){
      printf("Sorry, video mode %dx%d in %d bits isn't supported by hardware\n",
	     screen_width,screen_height,depth);
      exit(2);
    }
  }


  if(xscreensaver!=0){
    screen=SDL_SetVideoMode(screen_width,screen_height,0, SDL_NOFRAME);
  }
  else{
    if(keep_resolution)
      screen=SDL_SetVideoMode(screen_width,screen_height,0, SDL_NOFRAME);
    else
      screen=SDL_SetVideoMode(screen_width,screen_height,depth, SDL_FULLSCREEN);
  }


  if(screen == NULL){
    printf("Unable to set video mode %dx%d in %d bits.\n",
	   screen_width,screen_height,depth);
    exit(3);

  }

  /* Hide the mouse cursor */
  SDL_ShowCursor(0);

  /* Start with all black */
  SDL_FillRect(screen,NULL,0x000000);



  turn_fishes();

  fish_dest=g_malloc0(sizeof(SDL_Rect)*(mys.fishes+mys.bubbles));
  fish_src=g_malloc0(sizeof(SDL_Rect)*(mys.fishes+mys.bubbles));
  clean_dest=g_malloc0(sizeof(SDL_Rect)*(mys.fishes+mys.bubbles));

  dest.x=0;
  dest.y=0;
  dest.w=xmax;
  dest.h=ymax;

  screen_image=SDL_CreateRGBSurfaceFrom(a->rgb,xmax,ymax,24,xmax*3, 0x0000ff, 0x00ff00, 0xff0000, 0);
  background=SDL_CreateRGBSurfaceFrom(a->bgr,xmax,ymax,24,xmax*3, 0x0000ff, 0x00ff00, 0xff0000, 0);


  SDL_BlitSurface(screen_image,&dest,screen,&dest);
  SDL_UpdateRect(screen,0,0,0,0);

  totaltime1=clock();

  cali1=clock();

  while(!main_loop){

    /*Ignore sigterm signals from xscreensaver while doing updates.
      If not, gnome can make segfaults */
    /*    signal(SIGTERM,SIG_IGN); */

    curr_dest=0;
    clean_count=0;

    aquarium_update(NULL);

    for(i=0;i<curr_dest;i++){
      SDL_BlitSurface(thisfish[i],&fish_src[i],screen,&fish_dest[i]);
    }


    /* If we get a SIGTERM from xscreensaver in this loop, and we later do a SDL_Quit()
       X will get problems. So we have to avoid calling SDL_Quit if a sigterm is caught
       in this loop.

       Otherwise we get:
       Xlib: unexpected async reply (sequence 0xf03)!
       And sherman's starts eating processor power like hell!
    */

    no_sdl_quit=1;
    for(i=0;i<curr_dest;i++){
      SDL_UpdateRects(screen,1,&clean_dest[i]);
      SDL_FreeSurface(thisfish[i]);
    }
    no_sdl_quit=0;

    totalframes++;
    frames++;

    /* trying to calibrate so no matter what fishes that are displayed and on
       all machines, the number of frames should be max 50 per second. */

    /* After ten frames, 1/5 second should have passed by */

    /* But I doubt this piece of code is working at all! */

    if(frames==10){
      cali2=clock();

      /* Check if we're going too fast! */
      if((float)(cali2-cali1) < (float)(0.2*CLOCKS_PER_SEC)){
	delay=(int)(((float)((0.2*CLOCKS_PER_SEC)-(cali2-cali1))/CLOCKS_PER_SEC)*100000);
      }
      else{
	if(delay!=0){
	  if(delay<((int)(((float)((0.2*CLOCKS_PER_SEC)-(cali2-cali1))/CLOCKS_PER_SEC)*100000))){
	    delay-=(int)(((float)((0.2*CLOCKS_PER_SEC)-(cali2-cali1))/CLOCKS_PER_SEC)*100000);
	  }
	  else
	    delay=0;
	}
      }
      /*      printf("delay:%d\n",delay);*/
      cali1=clock();
      frames=0;
    }

    usleep(delay);



    while(SDL_PollEvent(&event)){

      if(escape_only){
	if(event.type==SDL_KEYDOWN)
	  if(event.key.keysym.sym == SDLK_ESCAPE) main_loop=1;
      }
      else{
	switch(event.type){
	case SDL_QUIT:
	  if(xscreensaver==0) main_loop=1;
	  break;
	case SDL_KEYDOWN:
	  num_events++;
	  if(num_events==2)
	    main_loop=1;
	  break;
	case SDL_MOUSEMOTION:
	  num_events++;
	  if(num_events==2)
	    main_loop=1;
	  break;
	case  SDL_MOUSEBUTTONDOWN:
	  num_events++;
	  if(num_events==2)
	    main_loop=1;
	  break;
	}
      }
    }

    
  }
  totaltime2=clock();
  printf("Frames: %d\n",totalframes);
  printf("Seconds: %f\n",(float)(totaltime2-totaltime1)/CLOCKS_PER_SEC);
  printf("FPS: %f\n",(float)totalframes/((float)(totaltime2-totaltime1)/CLOCKS_PER_SEC));

  fullscreen_quit();
}



void fullscreen_init(int width, int height)
{
  Window win=0;

  screen_height=height;
  screen_width=width;

  no_sdl_quit=0;

  xmax=windowsize_x=screen_width;
  ymax=windowsize_x=screen_height;
  
  virtual_aquarium_x = xmax + 2 * VIRTUAL_AQUARIUM_DX;
  virtual_aquarium_y = ymax + 2 * VIRTUAL_AQUARIUM_DY;



  if(xscreensaver!=0){
    if(display==NULL) display=XOpenDisplay(NULL);

    win = RootWindowOfScreen(ScreenOfDisplay(display, DefaultScreen(display)));

    sdl_command=g_strdup_printf("SDL_WINDOWID=%ld",win);
    putenv(sdl_command);
    /*
    g_free(sdl_command);
    */

  }


}
#endif
