#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "draw.h"
#include "aquarium.h"

#ifdef MATRIX

#include "matrix.h"

/*
   -Matrix scroller-
   Yes, I know this is really out of the subject.
   But one afternoon I was bored and felt for doing 
   this and nothing else.
*/

#define LETTERS 28

/* Make it stupid. Never more than thosen rows. */

int pauselist[1000];

char *fallindata[1000];
char charnum[1000];
int bright_x[10];
int bright_y[10];
int bright_num;
int letterx;
int lettery;
int xrows, yrows;
int not_free=0;
int matrix_inited=0;

unsigned char *matrix_dark;
unsigned char *matrix_bright;
unsigned char *matrix_screen;

GdkPixbuf *matrix_image, *matrix_image2;


/* This one is very alike to draw_fish - Only small differences.*/

void matrix_draw(int x, int y, int idx, int width, int height,
	  unsigned char *matrixpic)
{
    /* bounding box of the clipped sprite */
    int dw, di, dh, ds;
    /* loop counters */
    int w, h;
    /* offset into image buffer */
    int pos;

    int fidx;


    /* completely off the screen, don't bother drawing */
    if ((y < (-height)) || (y > (ymax)) || (x > (xmax)) || (x < -(width)))
	return;


    /* do clipping for top side */
    ds = 0;
    if (y < 0)
	ds = -(y);

    /* do clipping for bottom side */
    dh = height;
    if ((y + height) > ymax)
	dh = ymax - y;

    /* do clipping for right side */
    dw = width;
    if ((x + width) > xmax)
	dw = width - ((x + width) - xmax);

    /* do clipping for left side */
    di = 0;
    if (x < 0)
	di = -(x);

    fidx = width * height * 4 * idx;

	for (h = ds; h < dh; h++) {
	    /* offset to beginning of current row */
	    int ypos = (h + y) * xmax * 4;
	    for (w = di; w < dw; w++) {
		int pic_pos = h * width * 4 + w * 4 + fidx;
		pos = ypos + w * 4 + x * 4;
		if (matrixpic[pic_pos + 3] != 0) {
		    matrix_screen[pos] = matrixpic[pic_pos];
		    matrix_screen[pos + 1] = matrixpic[pic_pos + 1];
		    matrix_screen[pos + 2] = matrixpic[pic_pos + 2];
		    matrix_screen[pos + 3] = 1;
		}
	    }

	}

    
}


void make_matrix_line(int row, int start)
{
    int i,k,j;

    for(i=start;i<(start+20);i++){
	j=(rand() % 30)+1;
	if(j<LETTERS){
	  j=rand()%12+2;
	  for(k=i;((k<(i+j)) && (k<(start+20)));k++)
	    fallindata[row][k]=rand()%(LETTERS-1) + 1;
	}
	else{
	  j=(rand()%5)+10;
	  for(k=i;((k<(i+j)) && (k<(20+start)));k++)
	    fallindata[row][k]=0;
	} 
	i=k;
    }
}


void init_matrix_1(void)
{
    char *fname;
#ifdef GTK2
    GError *imerr=NULL;
#endif
    if(matrix_inited) return;
    matrix_inited=1;
        
    fname = filename("aquarium/matrix1.png");

#ifdef GTK2

    matrix_image = gdk_pixbuf_new_from_file(fname,&imerr);
    if(!matrix_image){
      display_file_error(fname,"init_matrix_1",imerr);
    }
    g_free(fname);

    fname = filename("aquarium/matrix2.png");
    matrix_image2 = gdk_pixbuf_new_from_file(fname, &imerr);
    if(!matrix_image2){
      display_file_error(fname,"init_matrix_1",imerr);
    }
#else

    matrix_image = gdk_pixbuf_new_from_file(fname);
    if(!matrix_image){
      display_file_error(fname,"init_matrix_1");
    }
    g_free(fname);

    fname = filename("aquarium/matrix2.png");
    matrix_image2 = gdk_pixbuf_new_from_file(fname);
    if(!matrix_image2){
      display_file_error(fname,"init_matrix_1");
    }

#endif

    g_free(fname);

    letterx = gdk_pixbuf_get_width(matrix_image);
    lettery = gdk_pixbuf_get_height(matrix_image)/LETTERS;

    matrix_dark = gdk_pixbuf_get_pixels(matrix_image);
    matrix_bright = gdk_pixbuf_get_pixels(matrix_image2);
    

}

void init_matrix_2(void)
{
  int i;
    
  bright_num=rand()%8;
  not_free=1;


  xrows = xmax/letterx+2;
  yrows = ymax/lettery+2;
  if(xrows>1000) printf("This will crash for sure!\n");

  for(i=0;i<bright_num;i++){
    bright_x[i]=rand()%xrows;
    bright_y[i]=rand()%yrows;
  }

  for(i=0;i<xrows;i++){
    pauselist[i]=0;
    fallindata[i] = g_malloc0(50);
    make_matrix_line(i,0);
    make_matrix_line(i,20);
    charnum[i]=rand()% 40;
  }
  matrix_screen=g_malloc0((xmax+2)*4*(ymax+2));

}


void free_matrix(void)
{
  int i;
    
  if(not_free){
    g_free(matrix_screen);
    for(i=0;i<xrows;i++)
      g_free(fallindata[i]);
    not_free=0;
  }
}

void free_matrix_all(void)
{
  free_matrix();
  gdk_pixbuf_unref(matrix_image);
  gdk_pixbuf_unref(matrix_image2);
  

}


void update_matrix(void)	
{
  int j,i,k,y,x=-4,c,a=0;
  int sum=0;

    
  for(j=0;j<xrows;j++){

    y=0;

    
    if(charnum[j]<35) a=5;
    else a=40-charnum[j];
    
    for(k=charnum[j];k<(charnum[j]+a);k++)
      sum+=(int)fallindata[j][k];
    
    if(sum==0 && pauselist[j]==-79){
      if(rand()%5==4) pauselist[j]=10;
    } 
    else
      pauselist[j]=-79;
     
    if(pauselist[j]<=0){
      charnum[j]--;
      if(charnum[j]==0) charnum[j]=40;
    }
    else
      pauselist[j]--;

    c=charnum[j];

    /* Draw all falling signs in a row */

    for(;;){ /* */

      matrix_draw(x,y,(int)fallindata[j][c],letterx,lettery,matrix_dark);
      
      if(c==10)
	make_matrix_line(j,20);
     
      if(c==30)
	make_matrix_line(j,0);

      if(c>=40) c=0;

      c++;
      y+=lettery;
      if(y>ymax) break;
    }
    x+=letterx;

  }
  for(i=0;i<bright_num;i++){
    matrix_draw(bright_x[i]*letterx-4, bright_y[i]*lettery,
	      (rand()%(LETTERS-1))+1, letterx,lettery,matrix_bright);
  }

}
#endif
