#ifndef _sinfocurses_h
#define _sinfocurses_h


#include <list>
#include <string>
#include <asio.hpp>
#include <boost/array.hpp>
#include <curses.h>
#include "sinfodata.h"
#include "sinfoviewconfig.h"


class SinfoCurses
{
private:
  asio::io_service & ioservice;
  SinfoViewConfig & config;
  SinfoData & sinfoData;
  std::list < Wsinfo > & wsinfoList; // located within sinfoData - to minimize code change

  bool colormode;
  int barState;
  WINDOW * win;
  int starty;
  int maxy;
  int y;

  void printInteractiveStatusLine(long cpuCount, float speedUsed, float speedSum);
  void printInteractiveOneHost(int maxy, int maxx, int & y, int & x, bool colormode, const Wsinfo & wsinfo, float speedMin, float speedMax);

  // keyboard handling   stdin => curses
  void handle_read(const asio::error_code& e, std::size_t bytes_transferred); // Handle completion of a read operation.
  asio::posix::stream_descriptor instream;                                    // stream on stdin
  boost::array<char, 8192> buffer_;                                           // Buffer for incoming data.

  void keyCodeEvent(int key);
  void wsinfoListChangedSlot();


  void printAll();


public:
  SinfoCurses(asio::io_service& io_service, SinfoViewConfig & _config, SinfoData & _sinfoData);

  void printInit();
};


#endif
