/* $Id: ip_options.h,v 1.3 2000/09/14 09:05:50 slay Exp $ */

#ifndef __IP_OPTIONS_H__
#define __IP_OPTIONS_H__

#include "ipcompat.h"
#include "packet.h"
#include "misc.h"

#define IP_OPT_DFL 40  /* Default IP options length */
#define MAX_IP_OPT  9  /* Maximum gways on a IP options header */

#define END_OPT  0
#define NOOP_OPT 1
#define RR_OPT   0x07
#define LSRR_OPT 0x83
#define SSRR_OPT 0x89

#define LOOSE_SYM  '@'
#define STRICT_SYM '%'
#define SR_SYMS    "@%"

/********************/
/* Global variables */
/********************/
u_long gway_ip[9];        

extern char *ip_opt_rcv;
extern char opt_len_rcv;
extern struct my_pack packet;
extern u_short verbose;
extern u_int cont_gways;


/************************/
/* Functions prototypes */
/************************/
void print_ip_opt(void);
void print_rr( void );
void print_lssrr( void );
void ip_opt_control( char * );
void make_ipopt( char *, int );

#if !defined(SOLARIS) && !defined(LINUX_20) && !defined(OPENBSD)
u_char vrfy_sr(void);
#endif

extern int exist_host( char *, u_long * );
extern void go_out( short int, char *, ... );
extern void go_out_error( short int, char * );
extern void write_log( u_short, char *, ...);
#endif