# Example starconvert specification file for Gliese data catalog
#  This file is used by the starconvert utility, packaged with StarPlot, which
#  can convert a line-oriented stellar data file into StarPlot format.

# Format: this file is separated into sections by words in [brackets].
#  All the allowed section names are used below.  Within each section a certain
#  set of keywords are allowed, each of which may take various arguments.
#  Keywords, numbers and strings must all be separated with semicolons.
#  (This is meant to make these specification files easier for starconvert
#  to parse correctly.)  Usually the arguments include the location within the
#  data file of each item.  For instance, if the spectral class is located in 
#  byte positions 55 through 66 of each line, you should have a line in this 
#  file under the [characteristics] section header that looks like:
# specclass; 55; 66
#  Note that byte positions are counted starting from 1, not 0.  Most star 
#  data files will come with a "ReadMe" file listing these byte positions,
#  allowing you to write your own starconvert spec file.

# "comments" is the one keyword which does not occur under a section header.
#  Use this if you need to extract information from a catch-all "Remarks"
#  field occurring in the star data file.
comments; 189; 257


[coordinates] #----------------------------------------------------------------

# This section specifies the star's coordinates on the celestial sphere,
#  i.e. its solid angle as seen from Earth.

type; celestial  # if type is "galactic", starconvert will convert to celestial

ra-hours; 13; 14 # long-deg will work as a synonym (intended for galactic mode)
ra-min;   16; 17 # synonym: long-min
ra-sec;   19; 20 # synonym: long-sec

dec-sign; 22     # if only one numerical arg, last byte = first byte
                 #  synonym: lat-sign
dec-deg;  23; 24 # synonym: lat-deg
dec-min;  26; 29 # synonym: lat-min
dec-sec          # if left out, or if no numerical args (like here), ignore
                 #  this field.  synonym: lat-sec


[characteristics] #------------------------------------------------------------

# specclass keyword should be self-explanatory.  You can have more than one of
#  these entries, with the later entries being used as fallbacks in case the
#  earlier entries are empty.
specclass; 55; 66

# distance and magnitude keywords must come in pairs, in order of most to least
#  desirable measurements.  For each star record, starconvert will use the
#  first pair which it is able to.  If a star's distance cannot be obtained
#  by any of the given rules, starconvert will not process it unless its name
#  is "Sun", in which case distance will be assumed to be zero and absolute
#  magnitude, if not given, to be +4.85.

# Format for magnitude keyword:
# magnitude; <mag-type>; <start>; <end>
#  where <mag-type> is one of {absolute, visual}.

# Allowed formats for distance keyword:

# distance; <distance-unit>; <start>; <end>
#  where <distance-unit> is one of {pc, ly}, i.e. parsecs or light-years.

# distance; <parallax-unit>; <start>; <end>
#  where <parallax-unit> is one of {arcsec, milliarcsec}.
#  Note: stars with a negative parallax will be automatically bumped to the
#  next rule which is not parallax-dependent, if any.

# distance; <parallax-unit>; <start>; <end>; <min-parallax>
#  allows you to skip this rule for all stars with a parallax less than
#  <min-parallax> (where <min-parallax> is in arcseconds, regardless of 
#  <parallax-unit>).
# Example - don't trust parallaxes < 0.04":
# distance;  milliarcsec; 109; 114; 0.04
# magnitude; absolute;    122; 126

# distance; <parallax-unit>; <start>; <end>; <err-start>; <err-end>; <max-err>
#  lets you specify a field for the ERROR in the parallax, from byte positions
#  <err-start> through <err-end>.  This field is assumed to have the same units
#  as <parallax-unit>.  You can then skip this rule for all stars with an
#  error in parallax which is greater than <max-err> * parallax.  (Note that
#  <max-err> is a real number which should be between zero and one.)  If
#  the parallax error for a particular star is not given, that star is
#  discarded from this rule automatically.
# Example - don't trust parallaxes with an error of greater than 25%:
# distance;  milliarcsec; 109; 114; 115; 119; 0.25
# magnitude; absolute;    122; 126

# distance; specclass
#  lets you use the star spectral class to estimate its absolute magnitude and
#  therefore distance.  This rule can only be used in combination with a visual
#  magnitude rule.
# Example:
# distance;  specclass
# magnitude; visual;    68; 73

# Here is the only rule we will actually use for the Gliese catalogue data:
distance;  milliarcsec; 109; 114
magnitude; absolute;    122; 126


[systems] #--------------------------------------------------------------------

# Use this section to specify double / triple / ... star system information.
#  This section is entirely optional; if it is left out, starconvert will
#  assume that stars which are less than 0.2 light-years apart are members
#  of the same star system and proceed accordingly.

# "component" should be one of A, B, C, etc. If this field is blank in the
#  star data file, starconvert assumes that star is a primary or single
component;  9; 10

# "separation" should be the angular separation.  Assumed in arc-sec unless
#  the separation is followed by an arc-minute symbol ' in the data file.
#  Allowed formats:
# separation; <start>; <end>
#  Specify byte position in each line of data file
# separation; comments; <prefix1>; <prefix2>; ...
#  Look in the comments field for the separation, assuming it's preceded by
#  one of the given prefixes.
separation; comments; a = ; Sep; sep


[names] #----------------------------------------------------------------------

# Put these in order of decreasing desirability.  Rearrange to your taste.

# Allowed formats:

# <type>; <start>; <end>
#  where <type> is one of {bayer,flamsteed,const-specific,dm},
#  will try to extract the desired type of name from the given byte positions.

# <type>; comments
#  where <type> is one of the above excluding `dm', will try to extract
#  the desired type of name from the comments string.

# other; <start>; <end>; <prefix>
#  will blindly extract a string from the given location, and add <prefix>
#  to the beginning of this string if it exists.  The string will be ignored
#  if it is empty.  If no prefix is given, it will be ignored unless it
#  contains at least three non-space characters.

# other; comments; <prefix1> = <sub1>; <prefix2> = <sub2>; ...
#  will search the comments string for each of the given prefixes, and for
#  each one found, starconvert will set a name equal to the prefix followed by
#  the next token in the comments string.  If <subn> exists, <prefixn> will be 
#  replaced by it after that prefix is found.

bayer;          comments # e.g. "Alpha Cen", "Tau Cet"
flamsteed;      comments # e.g. "40 Eri"
const-specific; comments # includes, e.g., "q Car", "VV Ori"
other;          comments; Ross; Wolf

other;          147; 152; HD # Henry Draper catalog number
dm;             154; 165     # Durchmusterung number BD / CD / CP
other;          comments; L = Luyten # i.e. substitute "Luyten" for "L"

other;          167; 175 # for Gliese catalog, this field is the Giclas number
other;          177; 181; LHS # for Gliese catalog, this field is LHS number
other;          183; 187 # for Gliese catalog, includes some other designations
other;          1; 8     # for Gliese catalog, includes Gliese and Woolley des.

# A whole bunch of other designations appear in the Gliese catalog "Remarks"
#  field, out of which I have no idea which ones are "preferred" by
#  astronomers; hence, they're alphabetical.  Rearrange as you like.

other;          comments; ADS; BPM; BS; CFS; DON; FK; GD; GJ; GR; GSC
other;          comments; Hei; Hy; IE; LDS; LE; LFT; LP; LTT; MW; NSV
other;          comments; PG; PS; RGO; Rob; RST; SA; San; Sm; Steph
other;          comments; USN; USNO; VA; VB; VVO; Wo; Wor; WOR


[substitutions] #--------------------------------------------------------------

# You use this section to add star names which do not exist in the data file,
#  or which cannot be easily extracted from it, such as proper names.

# Specify whether substitutions should occur only if the case of the star name
#  matches the case of the left-hand column below
case-insensitive # as opposed to case-sensitive

# For a star with name in the left column, starconvert will insert the name 
#  in the right column into the highest-priority position.

# Well-known common names of stars in the Gliese catalog:
Alpha CMa;         Sirius
Alpha Boo;         Arcturus
Alpha Lyr;         Vega
Alpha Aur;         Capella
Alpha CMi;         Procyon
Alpha Aql;         Altair
Alpha Tau;         Aldebaren
Beta Gem;          Pollux
Alpha PsA;         Fomalhaut
Alpha Gem;         Castor
HD 116842;         Alcor

# These are stars for which, oddly, Gliese et al overlooked Bayer designations.
#  There are probably others which I have missed.
HD 33111;          Beta Eri
HD 40183;          Beta Aur
HD 56537;          Lambda Gem
HD 71878;          Beta Vol
HD 81997;          Tau(1) Hya
HD 95418;          Beta UMa
HD 116656;         Zeta UMa
HD 118098;         Zeta Vir
HD 130819;         Alpha(1) Lib
HD 130841;         Alpha(2) Lib
HD 134505;         Zeta Lup
HD 138905;         Gamma Lib
HD 141795;         Epsilon Ser
HD 146791;         Epsilon Oph
HD 152786;         Zeta Ara
HD 156164;         Delta Her
HD 177241;         Omicron Sgr
HD 177716;         Tau Sgr
HD 177724;         Zeta Aql
HD 181577;         Rho(1) Sgr
HD 210418;         Theta Peg
HD 215665;         Lambda Peg
HD 215789;         Epsilon Gru
HD 216131;         Mu Peg

# You can substitute more than once for the same star, but the substitutions
#  have to be in the right order.
Zeta UMa;          Mizar # follows "HD 116656" -> "Zeta UMa" substitution above

# And some well-known nearby dwarf stars:
G001-027;          van Maanen's Star
HD 95735;          Lalande 21185

# We include BD designations both with and without degree sign , since StarPlot
# (as of version 0.92) may be compiled with or without extended ASCII support.
BD +043561a;      Barnard's Star
BD +04 3561a;      Barnard's Star

