/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    static int checkStyle(int style) {
        style = Widget.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int clientHandle() {
        int index = OS.gtk_notebook_get_current_page((int)this.handle);
        if (index != -1 && this.items[index] != null) {
            return this.items[index].pageHandle;
        }
        return this.handle;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int width = OS.GTK_WIDGET_WIDTH((int)this.fixedHandle);
        int height = OS.GTK_WIDGET_HEIGHT((int)this.fixedHandle);
        OS.gtk_widget_set_size_request((int)this.handle, (int)wHint, (int)hHint);
        GtkRequisition requisition = new GtkRequisition();
        boolean scrollable = OS.gtk_notebook_get_scrollable((int)this.handle);
        OS.gtk_notebook_set_scrollable((int)this.handle, (boolean)false);
        OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
        OS.gtk_notebook_set_scrollable((int)this.handle, (boolean)scrollable);
        OS.gtk_widget_set_size_request((int)this.handle, (int)width, (int)height);
        width = wHint == -1 ? requisition.width : wHint;
        height = hHint == -1 ? requisition.height : hHint;
        Point size = this.layout != null ? this.layout.computeSize(this, wHint, hHint, changed) : this.minimumSize(wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        width = Math.max(width, size.x);
        height = Math.max(height, size.y);
        return new Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int clientHandle = this.clientHandle();
        int clientX = OS.GTK_WIDGET_X((int)clientHandle);
        int clientY = OS.GTK_WIDGET_Y((int)clientHandle);
        x -= clientX;
        y -= clientY;
        width += clientX + clientX;
        if ((this.style & 0x400) != 0) {
            int parentHeight = OS.GTK_WIDGET_HEIGHT((int)this.handle);
            int clientHeight = OS.GTK_WIDGET_HEIGHT((int)clientHandle);
            height += parentHeight - clientHeight;
        } else {
            height += clientX + clientY;
        }
        return new Rectangle(x, y, width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.gtk_fixed_new();
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window((int)this.fixedHandle, (boolean)true);
        this.handle = OS.gtk_notebook_new();
        if (this.handle == 0) {
            this.error(2);
        }
        int parentHandle = this.parent.parentingHandle();
        OS.gtk_container_add((int)parentHandle, (int)this.fixedHandle);
        OS.gtk_container_add((int)this.fixedHandle, (int)this.handle);
        OS.gtk_widget_show((int)this.handle);
        OS.gtk_widget_show((int)this.fixedHandle);
        OS.gtk_notebook_set_scrollable((int)this.handle, (boolean)true);
        OS.gtk_notebook_set_show_tabs((int)this.handle, (boolean)true);
        if ((this.style & 0x400) != 0) {
            OS.gtk_notebook_set_tab_pos((int)this.handle, (int)3);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TabItem[4];
    }

    void createItem(TabItem item, int index) {
        int imageHandle;
        int labelHandle;
        int boxHandle;
        int list = OS.gtk_container_get_children((int)this.handle);
        int itemCount = 0;
        if (list != 0) {
            itemCount = OS.g_list_length((int)list);
            OS.g_list_free((int)list);
        }
        if (index < 0 || index > itemCount) {
            this.error(6);
        }
        if (itemCount == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        if ((boxHandle = OS.gtk_hbox_new((boolean)false, (int)0)) == 0) {
            this.error(2);
        }
        if ((labelHandle = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((imageHandle = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add((int)boxHandle, (int)imageHandle);
        OS.gtk_container_add((int)boxHandle, (int)labelHandle);
        int pageHandle = OS.gtk_fixed_new();
        if (pageHandle == 0) {
            this.error(2);
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)36);
        OS.gtk_notebook_insert_page((int)this.handle, (int)pageHandle, (int)boxHandle, (int)index);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)36);
        OS.gtk_widget_show((int)boxHandle);
        OS.gtk_widget_show((int)labelHandle);
        OS.gtk_widget_show((int)pageHandle);
        item.state |= 8;
        item.handle = boxHandle;
        item.labelHandle = labelHandle;
        item.imageHandle = imageHandle;
        item.pageHandle = pageHandle;
        System.arraycopy(this.items, index, this.items, index + 1, itemCount++ - index);
        this.items[index] = item;
        item.setForegroundColor(this.getForegroundColor());
        item.setFontDescription(this.getFontDescription());
        if (itemCount == 1) {
            this.fixPage();
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void fixPage() {
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)36);
        int flags = OS.GTK_WIDGET_FLAGS((int)this.handle);
        OS.GTK_WIDGET_SET_FLAGS((int)this.handle, (int)256);
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request((int)this.handle, (GtkRequisition)requisition);
        OS.gtk_container_resize_children((int)this.handle);
        if ((flags & 0x100) == 0) {
            OS.GTK_WIDGET_UNSET_FLAGS((int)this.handle, (int)256);
        }
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)36);
    }

    void destroyItem(TabItem item) {
        int index = 0;
        int itemCount = this.getItemCount();
        while (index < itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == itemCount) {
            this.error(15);
        }
        int oldIndex = OS.gtk_notebook_get_current_page((int)this.handle);
        item.deregister();
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)36);
        OS.gtk_notebook_remove_page((int)this.handle, (int)index);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)36);
        System.arraycopy(this.items, index + 1, this.items, index, --itemCount - index);
        this.items[itemCount] = null;
        item.labelHandle = 0;
        item.imageHandle = 0;
        item.pageHandle = 0;
        item.handle = 0;
        if (index == oldIndex) {
            this.fixPage();
            int newIndex = OS.gtk_notebook_get_current_page((int)this.handle);
            if (newIndex != -1) {
                Control control = this.items[newIndex].getControl();
                if (control != null && !control.isDisposed()) {
                    control.setBounds(this.getClientArea());
                    control.setVisible(true);
                }
                Event event = new Event();
                event.item = this.items[newIndex];
                this.sendEvent(13, event);
            }
        }
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    public TabItem getItem(int index) {
        int list;
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        if ((list = OS.gtk_container_get_children((int)this.handle)) == 0) {
            this.error(8);
        }
        int itemCount = OS.g_list_length((int)list);
        OS.g_list_free((int)list);
        if (index < 0 || index >= itemCount) {
            this.error(8);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        int list = OS.gtk_container_get_children((int)this.handle);
        if (list == 0) {
            return 0;
        }
        int itemCount = OS.g_list_length((int)list);
        OS.g_list_free((int)list);
        return itemCount;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        TabItem[] result = new TabItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = OS.gtk_notebook_get_current_page((int)this.handle);
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.gtk_notebook_get_current_page((int)this.handle);
    }

    int gtk_focus(int widget, int directionType) {
        return 0;
    }

    int gtk_switch_page(int widget, int page, int page_num) {
        TabItem item;
        Control control;
        Control control2;
        int index = OS.gtk_notebook_get_current_page((int)this.handle);
        if (index != -1 && (control2 = this.items[index].getControl()) != null && !control2.isDisposed()) {
            control2.setVisible(false);
        }
        if ((control = (item = this.items[page_num]).getControl()) != null && !control.isDisposed()) {
            control.setBounds(this.getClientArea());
            control.setVisible(true);
        }
        Event event = new Event();
        event.item = item;
        this.postEvent(13, event);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect((int)this.handle, (byte[])OS.switch_page, (int)this.display.windowProc4, (int)36);
    }

    public int indexOf(TabItem item) {
        int list;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if ((list = OS.gtk_container_get_children((int)this.handle)) == 0) {
            return -1;
        }
        int count = OS.g_list_length((int)list);
        OS.g_list_free((int)list);
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            int count = 0;
            int list = OS.gtk_container_get_children((int)this.handle);
            if (list != 0) {
                count = OS.g_list_length((int)list);
                OS.g_list_free((int)list);
            }
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    boolean mnemonicHit(char key) {
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            int labelHandle = this.items[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean mnemonicMatch(char key) {
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            int labelHandle = this.items[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void releaseWidget() {
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int count = this.getItemCount();
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int index;
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (changed && resize && (index = this.getSelectionIndex()) != -1) {
            TabItem item = this.items[index];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return changed;
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setFontDescription(font);
            }
            ++i;
        }
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        TabItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].setForegroundColor(color);
            }
            ++i;
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        if (index < 0) {
            return;
        }
        int oldIndex = OS.gtk_notebook_get_current_page((int)this.handle);
        if (oldIndex != -1) {
            TabItem item = this.items[oldIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        OS.g_signal_handlers_block_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)36);
        OS.gtk_notebook_set_current_page((int)this.handle, (int)index);
        OS.g_signal_handlers_unblock_matched((int)this.handle, (int)16, (int)0, (int)0, (int)0, (int)0, (int)36);
        int newIndex = OS.gtk_notebook_get_current_page((int)this.handle);
        if (newIndex != -1) {
            TabItem item = this.items[newIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendEvent(13, event);
            }
        }
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i;
            }
        }
    }
}

