# Config file for Mixed demo

from Synopsis.Config import Base

class Config (Base):
    class Parser:
	class CXX (Base.Parser.CXX):
	    include_path = ['.']
	    main_file = 1
	    preprocessor = 'gcc'
	modules = {
	    'C++':CXX,
	    'IDL':Base.Parser.IDL,
	}
	    
    class Linker:
	class Linker (Base.Linker.Linker):
	    comment_processors = ['ssd']
	class Mapping (Linker):
	    mappers = [
		'C++toIDL', #Use builtin mapper
	    ]
	modules = {
	    'Linker':Linker,
	    'Mapping':Mapping,
	}

    class Formatter:
	class HTML (Base.Formatter.HTML):
	    stylesheet_file = '../html.css'
	class Interface (HTML):
	    toc_out = 'interface.toc'
	class Implementation (HTML):
	    toc_in = ['interface.toc|../interface']
	modules = {
	    'Interface':Interface,
	    'Implementation':Implementation,
	}
