#ifndef INDII_TINT_IMAGECACHE_HPP
#define INDII_TINT_IMAGECACHE_HPP

#include "wx/image.h"

#include <map>

namespace indii {
  namespace tint {

/**
 * Cache of various versions of an image.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
class ImageCache {
public:
  /**
   * Constructor.
   *
   * @param image Original image.
   * @param high Should images be resized in high quality?
   */
  ImageCache(wxImage* image, const bool high = false);
      
  /**
   * Destructor.
   */
  virtual ~ImageCache();
  
  /**
   * Get resized image.
   *
   * @param width Width of the image.
   * @param height Height of the image.
   *
   * @return The resized image, drawn from the cache if available.
   *
   * If either @p width or @p height is <= 0, the original image is
   * returned.
   */
  wxImage* get(const int width = 0, const int height = 0);

private:
  /**
   * Image dimension.
   */
  typedef std::pair<const int, const int> dim_t;
  
  /**
   * Image cache.
   */
  typedef std::map<dim_t,wxImage*> cache_t;
  
  /**
   * Image cache pair.
   */
  typedef std::pair<dim_t,wxImage*> cache_pair_t;
  
  /**
   * Original image.
   */
  wxImage* original;
  
  /**
   * Cache.
   */
  cache_t cache;

  /**
   * Should images be resized in high quality?
   */
  const bool high;
  
};
  
  }
}

#endif
