#ifndef INDII_TINT_GUI_TINTAPP_HPP
#define INDII_TINT_GUI_TINTAPP_HPP

#include "TintSplash.hpp"
#include "TintRegistration.hpp"
#include "TintWindow.hpp"
#include "../ImageResource.hpp"
#include "../ClusterModel.hpp"
#include "TintWindowObserver.hpp"

#include "wx/app.h"
#include "wx/cmdline.h"

#include <set>

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Tint wxWidgets application.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 109 $
 * @date $Date: 2009-09-12 17:28:14 +0800 (Sat, 12 Sep 2009) $
 */
class TintApp : public wxApp, public TintWindowObserver {
public:
  virtual void MacOpenFile(const wxString &file);
  
  virtual bool OnInit();
  
  void OnInitCmdLine(wxCmdLineParser& parser);

  bool OnCmdLineParsed(wxCmdLineParser& parser);

  /**
   * Open button event.
   */
  void OnButtonOpen(wxCommandEvent& evt);
  
  /**
   * Exit button event.
   */
  void OnButtonExit(wxCommandEvent& evt);
  
  /**
   * Register button event.
   */
  void OnButtonRegister(wxCommandEvent& evt);
  
  /**
   * About button event.
   */
  void OnButtonAbout(wxCommandEvent& evt);
  
  /**
   * Splash button event.
   */
  void OnButtonSplash(wxCommandEvent& evt);
  
  virtual int OnExit();

  /**
   * Notify that splash screen is closing.
   *
   * @param splash The splash screen.
   */
  void notifySplashClose(TintSplash* splash);
  
  /**
   * Notify that window is closing.
   *
   * @param window The window being closed.
   */
  virtual void notifyClose(TintWindow* window);
  
private:
  /**
   * Image resources.
   */
  indii::tint::ImageResource* res;

  /**
   * Cluster model.
   */
  indii::tint::ClusterModel* model;

  /**
   * Splash screen.
   */
  TintSplash* splash;

  /**
   * Registration dialog.
   */
  TintRegistration* dlgRegister;
  
  /**
   * Open editors.
   */
  std::set<TintWindow*> windows;
  
  /*
   * Control ids.
   */
  enum ID {
    ID_BUT_REGISTER,
    ID_BUT_SPLASH
  };
  
  DECLARE_EVENT_TABLE()
};

    }
  }
}

#endif
