#include "TintRegistration.hpp"

#include "../reg/Components.hpp"
#include "../../../nuvola/nuvola.hpp"

#include "wx/gbsizer.h"
#include "wx/stattext.h"
#include "wx/textctrl.h"
#include "wx/utils.h"
#include "wx/statbmp.h"

using namespace indii::tint;
using namespace indii::tint::gui;
using namespace indii::tint::reg;

#ifdef __WXMAC__
/* modal dialogs shouldn't have close button */
#define TINTREGISTRATION_STYLE wxCAPTION
#else
#define TINTREGISTRATION_STYLE wxDEFAULT_DIALOG_STYLE
#endif

TintRegistration::TintRegistration(wxWindow* parent) :
    wxDialog(parent, wxID_ANY, _("Register"),
    wxDefaultPosition, wxDefaultSize, TINTREGISTRATION_STYLE) {
  static const int PADDING = 8;

  wxStaticBitmap* bmpKey = new wxStaticBitmap(this, wxID_ANY,
      *_img_nuvola_password);
  wxStaticText* lblDesc = new wxStaticText(this, wxID_ANY,
      _("Register to enable your plugin for Adobe Photoshop or Corel Paint "
      "Shop Pro, the recommended way of using tintii.\n\nTo register, purchase "
      "an activation key at the URL below and enter it here."));
  wxButton* butUrl = new wxButton(this, ID_BUT_URL,
      _("www.indii.org/software/tintii/register"));

  lblDesc->Wrap(240);
  
  #ifndef __WXMAC__
  wxFont fntUrl(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
  fntUrl.SetUnderlined(true);
  butUrl->SetFont(fntUrl);
  butUrl->SetForegroundColour(*wxBLUE);
  #endif
      
  txtKey = new wxTextCtrl(this, wxID_ANY, wxEmptyString, wxDefaultPosition,
      wxSize(160,-1));

  wxGridBagSizer* keySizer = new wxGridBagSizer();
  keySizer->Add(bmpKey, wxGBPosition(0,0), wxDefaultSpan,
      wxALL|wxALIGN_CENTRE_VERTICAL, PADDING);
  keySizer->Add(txtKey, wxGBPosition(0,1), wxDefaultSpan,
      wxALL|wxALIGN_CENTRE_VERTICAL, PADDING);

  wxGridBagSizer* sizer = new wxGridBagSizer();
  sizer->Add(lblDesc, wxGBPosition(0,0), wxDefaultSpan,
      wxALL|wxEXPAND, PADDING);
  sizer->Add(keySizer, wxGBPosition(1,0), wxDefaultSpan,
      wxALIGN_CENTRE_HORIZONTAL);
  sizer->Add(butUrl, wxGBPosition(2,0), wxDefaultSpan,
      wxALL|wxALIGN_CENTRE_HORIZONTAL|wxEXPAND, PADDING);

  wxSizer* buttonSizer = this->CreateButtonSizer(wxOK|wxCANCEL);
  sizer->Add(buttonSizer, wxGBPosition(3,0), wxGBSpan(1,2), wxALL|wxEXPAND,
      PADDING);

  SetSizerAndFit(sizer);
}

TintRegistration::~TintRegistration() {  
  //
}

void TintRegistration::OnButtonUrl(wxCommandEvent& evt) {
  wxLaunchDefaultBrowser(_("http://www.indii.org/software/tintii/register"));
}

void TintRegistration::OnButtonOk(wxCommandEvent& evt) {
  if (Components::activate(Components::PS_FILTER, txtKey->GetValue())) {
    EndModal(wxID_OK);
  }
}

void TintRegistration::OnButtonCancel(wxCommandEvent& evt) {
  EndModal(wxID_CANCEL);
}

void TintRegistration::OnClose(wxCloseEvent& evt) {
  Destroy();
}

BEGIN_EVENT_TABLE(TintRegistration, wxDialog)
EVT_CLOSE(TintRegistration::OnClose)
EVT_BUTTON(ID_BUT_URL, TintRegistration::OnButtonUrl)
EVT_BUTTON(wxID_OK, TintRegistration::OnButtonOk)
EVT_BUTTON(wxID_CANCEL, TintRegistration::OnButtonCancel)
END_EVENT_TABLE()
