/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 395 $
 * $Date: 2012-02-19 12:59:25 +0800 (Sun, 19 Feb 2012) $
 */
#include "About.hpp"

#include "../meta.hpp"

#include "wx/aboutdlg.h"

void indii::showAboutDialog(wxWindow* parent) {
  wxAboutDialogInfo info;
  
  #ifdef __WXOSX__
  /* on Mac, generic about dialog is not modal which causes issues in Photoshop,
   * not providing a URL ensures native dialog is used instead */
  info.SetName(_("indii.org / " PACKAGE_NAME));
  info.SetVersion(_("Mac"), _(PACKAGE_VERSION));
  info.SetDescription(_(PACKAGE_DESC));
  info.SetCopyright(_("Copyright 2007-2012 Lawrence Murray"));
  #else
  info.SetName(_(PACKAGE_NAME));
  info.SetVersion(_(PACKAGE_VERSION));
  info.SetDescription(_(PACKAGE_DESC));
  info.SetWebSite(_("http://www.indii.org/" PACKAGE_TARNAME));
  info.SetCopyright(_("Copyright 2007-2012 Lawrence Murray"));
  #endif
  
  #ifndef WX_28
  wxAboutBox(info, parent);
  #else
  wxAboutBox(info);
  #endif
}
